/*
 * Decompiled with CFR 0.152.
 */
package test;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bdware.doip.codec.digitalObject.DigitalObject;
import org.bdware.doip.codec.doipMessage.DoipMessage;
import org.bdware.doip.endpoint.client.ClientConfig;
import org.bdware.doip.endpoint.client.DoipClientImpl;
import org.bdware.doip.endpoint.client.DoipMessageCallback;
import test.DoExample;

public class DoipClientTest {
    static Logger LOGGER = LogManager.getLogger(DoipClientTest.class);
    String serverAddr = "tcp://127.0.0.1:21042";

    public void testRetrieveReconnect() throws InterruptedException {
        long start = System.currentTimeMillis();
        final AtomicInteger total = new AtomicInteger(0);
        final AtomicInteger correct = new AtomicInteger(0);
        int totalCount = 10000;
        for (int i = 0; i < totalCount; ++i) {
            final DoipClientImpl doipClient = new DoipClientImpl();
            doipClient.connect(ClientConfig.fromUrl("tcp://127.0.0.1:1717"));
            doipClient.retrieve("aibd/do.e626924a-3b1c-492f-9a41-59179bfe0361", null, true, new DoipMessageCallback(){

                @Override
                public void onResult(DoipMessage msg) {
                    String str = new String(msg.body.encodedData);
                    total.incrementAndGet();
                    if (str.contains("aaa")) {
                        correct.incrementAndGet();
                    }
                    if (doipClient != null) {
                        doipClient.close();
                    }
                }
            });
        }
        int circle = 0;
        while (total.get() < totalCount) {
            if (++circle % 100 == 0) {
                LOGGER.info(String.format("%d/%d", correct.get(), total.get()));
            }
            Thread.sleep(10L);
        }
        int dur = (int)(System.currentTimeMillis() - start);
        LOGGER.info(String.format("Final Result:%d/%d dur:%d", correct.get(), total.get(), dur));
    }

    public void retrieveSmallReqSmallResp() throws InterruptedException {
        this.testRetrive(this.serverAddr, 1000000, "bdware.test/small");
    }

    public void retrieveSmallReqLargeResp() throws InterruptedException {
        this.testRetrive(this.serverAddr, 100, "bdware.test/large");
    }

    public void updateLargeReqSmallResp() throws InterruptedException {
        String id = "bdware.test/small";
        DigitalObject digitalObject = DoExample.large;
        digitalObject.id = id;
        this.testUpdate(this.serverAddr, 100, digitalObject);
    }

    public void updateLargeReqLargeResp() throws InterruptedException {
        String id = "bdware.test/large";
        DigitalObject digitalObject = DoExample.large;
        digitalObject.id = id;
        this.testUpdate(this.serverAddr, 100, digitalObject);
    }

    public void testUpdate(String addr, int totalCount, DigitalObject digitalObject) throws InterruptedException {
        DoipClientImpl doipClient = new DoipClientImpl();
        doipClient.connect(ClientConfig.fromUrl(addr));
        long start = System.currentTimeMillis();
        final AtomicInteger total = new AtomicInteger(0);
        final AtomicInteger correct = new AtomicInteger(0);
        for (int i = 0; i < totalCount; ++i) {
            doipClient.update(digitalObject, new DoipMessageCallback(){

                @Override
                public void onResult(DoipMessage msg) {
                    try {
                        DigitalObject digitalObject = DigitalObject.fromByteArray(msg.body.encodedData);
                        String str = new String(digitalObject.elements.get(0).getData());
                        if (str.startsWith("cold")) {
                            correct.incrementAndGet();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    total.incrementAndGet();
                }
            });
        }
        int circle = 0;
        while (total.get() < totalCount) {
            if (++circle % 100 == 0) {
                LOGGER.info(String.format("%d/%d", correct.get(), total.get()));
            }
            Thread.sleep(10L);
        }
        int dur = (int)(System.currentTimeMillis() - start);
        LOGGER.info(String.format("Final Result:%d/%d dur:%d rps:%.2f", correct.get(), total.get(), dur, ((double)correct.get() + 0.0) * 1000.0 / (double)dur));
    }

    public TestResult testRetriveWithTime(String serverAddr, int reqDur, String id) {
        DoipClientImpl doipClient = new DoipClientImpl();
        doipClient.connect(ClientConfig.fromUrl(serverAddr));
        doipClient.waitForConnected();
        final AtomicInteger total = new AtomicInteger(0);
        final AtomicInteger correct = new AtomicInteger(0);
        AtomicInteger sent = new AtomicInteger(0);
        long start = System.currentTimeMillis();
        long curr = System.currentTimeMillis();
        while (curr - start < (long)reqDur) {
            sent.incrementAndGet();
            doipClient.retrieve(id, null, true, new DoipMessageCallback(){

                @Override
                public void onResult(DoipMessage msg) {
                    try {
                        DigitalObject digitalObject = DigitalObject.fromByteArray(msg.body.encodedData);
                        String str = new String(digitalObject.elements.get(0).getData());
                        if (str.startsWith("cold")) {
                            correct.incrementAndGet();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    total.incrementAndGet();
                }
            });
            curr = System.currentTimeMillis();
        }
        long lastNotify = System.currentTimeMillis();
        while (sent.get() != total.get()) {
            Thread.yield();
            if (System.currentTimeMillis() - lastNotify <= 10000L) continue;
            LOGGER.info("wait for msgs: sent" + sent.get() + " rec:" + total.get());
            lastNotify = System.currentTimeMillis();
        }
        int dur = (int)(System.currentTimeMillis() - start);
        LOGGER.info(String.format("%s Final Result:%d/%d dur:%d rps:%.2f", serverAddr, correct.get(), total.get(), dur, ((double)correct.get() + 0.0) * 1000.0 / (double)dur));
        TestResult result = new TestResult();
        result.correct = correct.get();
        result.total = total.get();
        result.rps = ((double)correct.get() + 0.0) * 1000.0 / (double)dur;
        result.dur = dur;
        return result;
    }

    public TestResult testRetrive(String addr, int totalCount, String id) throws InterruptedException {
        DoipClientImpl doipClient = new DoipClientImpl();
        doipClient.connect(ClientConfig.fromUrl(addr));
        doipClient.waitForConnected();
        long start = System.currentTimeMillis();
        final AtomicInteger total = new AtomicInteger(0);
        final AtomicInteger correct = new AtomicInteger(0);
        for (int i = 0; i < totalCount; ++i) {
            doipClient.retrieve(id, null, true, new DoipMessageCallback(){

                @Override
                public void onResult(DoipMessage msg) {
                    try {
                        DigitalObject digitalObject = DigitalObject.fromByteArray(msg.body.encodedData);
                        String str = new String(digitalObject.elements.get(0).getData());
                        if (str.startsWith("cold")) {
                            correct.incrementAndGet();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    total.incrementAndGet();
                }
            });
        }
        int circle = 0;
        while (total.get() < totalCount) {
            if (++circle % 100 == 0) {
                LOGGER.info(String.format("%d/%d", correct.get(), total.get()));
            }
            Thread.sleep(10L);
        }
        int dur = (int)(System.currentTimeMillis() - start);
        LOGGER.info(String.format("%s Final Result:%d/%d dur:%d rps:%.2f", this.serverAddr, correct.get(), total.get(), dur, ((double)correct.get() + 0.0) * 1000.0 / (double)dur));
        TestResult result = new TestResult();
        result.correct = correct.get();
        result.total = total.get();
        result.rps = ((double)correct.get() + 0.0) * 1000.0 / (double)dur;
        result.dur = dur;
        return result;
    }

    static class TestResult {
        long dur;
        double rps;
        int total;
        int correct;

        TestResult() {
        }
    }
}

