/*
 * Decompiled with CFR 0.152.
 */
package test;

import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import test.DoipClientTest;

public class MultiThreadDoipClientTest {
    static Logger LOGGER = LogManager.getLogger(MultiThreadDoipClientTest.class);
    static int threadCount = 30;
    static int reqDur = 180;
    static String serverAddr = "tcp://127.0.0.1:21042";
    static Executor executor = Executors.newFixedThreadPool(threadCount);

    public static void main(String[] args) {
        if (args.length > 0) {
            serverAddr = args[0];
            threadCount = Integer.valueOf(args[1]);
            reqDur = Integer.valueOf(args[2]);
        }
        new MultiThreadDoipClientTest().run();
    }

    public void run() {
        DoipClientTest.TestResult total = new DoipClientTest.TestResult();
        final AtomicInteger counter = new AtomicInteger(0);
        final AtomicInteger totalRps = new AtomicInteger(0);
        for (int i = 0; i < threadCount; ++i) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    DoipClientTest test = new DoipClientTest();
                    try {
                        DoipClientTest.TestResult result = test.testRetriveWithTime(serverAddr, reqDur, "bdware.test/small");
                        totalRps.addAndGet((int)result.rps);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    counter.getAndIncrement();
                }
            });
        }
        while (counter.get() < threadCount) {
            Thread.yield();
        }
        LOGGER.info("totalRps:" + totalRps.get());
    }
}

