/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.doip.codec;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageCodec;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bdware.doip.codec.MessageEnvelopeBuffer;
import org.bdware.doip.codec.doipMessage.DoipMessage;
import org.bdware.doip.codec.doipMessage.HeaderParameter;
import org.bdware.doip.codec.doipMessage.MessageCredential;
import org.bdware.doip.codec.doipMessage.MessageEnvelope;
import org.bdware.doip.codec.exception.MessageCodecException;
import org.bdware.doip.codec.utils.DoipGson;

public class MessageEnvelopeAggregator
extends MessageToMessageCodec<MessageEnvelope, DoipMessage> {
    public static final int MTU_ethernet = 1500;
    public static final int MTU_802_3 = 1492;
    final int mtu;
    Map<Integer, MessageEnvelopeBuffer> messageEnvelopeBufferMap = new ConcurrentHashMap<Integer, MessageEnvelopeBuffer>();

    public MessageEnvelopeAggregator() {
        this(1492);
    }

    public MessageEnvelopeAggregator(int mtu) {
        this.mtu = mtu;
    }

    private int getMTU() {
        return this.mtu;
    }

    protected void encode(ChannelHandlerContext ctx, DoipMessage msg, List<Object> out) throws Exception {
        this.messageToEnvelopes(msg, out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageToEnvelopes(DoipMessage msg, List<Object> out) throws MessageCodecException {
        ByteBuf bf = Unpooled.directBuffer();
        try {
            msg.header.parameterLength = msg.header.parameters.length();
            msg.header.bodyLength = msg.body.getLength();
            bf.writeInt(msg.header.getFlag());
            bf.writeInt(msg.header.parameterLength);
            bf.writeInt(msg.header.bodyLength);
            if (msg.header.parameterLength != 0 && msg.header.parameterLength != msg.header.parameters.length()) {
                throw new MessageCodecException("invalid parameter length: " + msg.header.parameterLength);
            }
            bf.writeBytes(msg.header.parameters.toByteArray());
            if (msg.header.bodyLength != 0 && msg.header.bodyLength != msg.body.getLength()) {
                throw new MessageCodecException("invalid body length: " + msg.header.parameterLength);
            }
            bf.writeBytes(msg.body.getEncodedData());
            if (msg.credential != null) {
                bf.writeInt(msg.credential.attributeLength());
                bf.writeBytes(DoipGson.getDoipGson().toJson((JsonElement)msg.credential.attributes).getBytes(StandardCharsets.UTF_8));
                bf.writeInt(msg.credential.sigLength());
                bf.writeBytes(msg.credential.getSignature());
            }
            int encodedLength = bf.readableBytes();
            int totalNumber = (encodedLength - 1) / this.mtu + 1;
            InetSocketAddress sender = msg.getSender();
            while (bf.isReadable()) {
                int readindex;
                MessageEnvelope env = new MessageEnvelope(sender);
                if (bf.readableBytes() <= this.mtu) {
                    readindex = bf.readerIndex();
                    int toread = bf.readableBytes();
                    env.content = bf.retainedSlice(readindex, toread);
                    bf.readerIndex(readindex + toread);
                    env.setTruncated(totalNumber > 1);
                    env.setEncrypted(msg.header.isEncrypted());
                    env.sequenceNumber = out.size();
                    env.totalNumber = totalNumber;
                    env.requestId = msg.requestID;
                    env.contentLength = env.content.readableBytes();
                    out.add(env);
                    break;
                }
                readindex = bf.readerIndex();
                env.content = bf.retainedSlice(readindex, this.mtu);
                bf.readerIndex(readindex + this.getMTU());
                env.setTruncated(totalNumber > 1);
                env.setEncrypted(msg.header.isEncrypted());
                env.sequenceNumber = out.size();
                env.totalNumber = totalNumber;
                env.requestId = msg.requestID;
                env.contentLength = env.content.readableBytes();
                out.add(env);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            bf.release();
        }
    }

    protected void decode(ChannelHandlerContext ctx, MessageEnvelope msg, List<Object> out) throws Exception {
        if (!msg.isResend()) {
            if (msg.isTruncated()) {
                MessageEnvelopeBuffer buff;
                if (this.messageEnvelopeBufferMap.containsKey(msg.requestId)) {
                    buff = this.messageEnvelopeBufferMap.get(msg.requestId);
                } else {
                    buff = new MessageEnvelopeBuffer(msg.requestId);
                    this.messageEnvelopeBufferMap.put(msg.requestId, buff);
                }
                buff.add(msg);
                if (buff.isComplete()) {
                    DoipMessage doipMessage = MessageEnvelopeAggregator.byteBufToMessage(buff.toByteBuf(), msg.requestId);
                    doipMessage.setSender(buff.getSender());
                    doipMessage.header.setIsEncrypted(msg.isEncrypted());
                    out.add(doipMessage);
                    this.messageEnvelopeBufferMap.remove(msg.requestId);
                }
            } else {
                DoipMessage doipMessage = MessageEnvelopeAggregator.byteBufToMessage(msg.content, msg.requestId);
                doipMessage.setSender(msg.getSender());
                doipMessage.header.setIsEncrypted(msg.isEncrypted());
                out.add(doipMessage);
            }
        }
    }

    public static DoipMessage byteBufToMessage(ByteBuf bf, int requestId) throws MessageCodecException {
        DoipMessage msg = new DoipMessage("", "");
        msg.requestID = requestId;
        msg.header.setFlag(bf.readInt());
        msg.header.parameterLength = bf.readInt();
        msg.header.bodyLength = bf.readInt();
        byte[] parameters = new byte[msg.header.parameterLength];
        bf.readBytes(parameters);
        msg.header.parameters = (HeaderParameter)DoipGson.getDoipGson().fromJson(new String(parameters), HeaderParameter.class);
        if (msg.header.bodyLength > 0) {
            if (bf.readableBytes() < msg.header.bodyLength) {
                throw new MessageCodecException("invalid body length");
            }
            msg.body.encodedData = new byte[msg.header.bodyLength];
            bf.readBytes(msg.body.encodedData);
        }
        if (bf.readableBytes() > 0) {
            byte[] attrBytes = MessageEnvelopeAggregator.readDataArray(bf);
            JsonObject attrJo = (JsonObject)DoipGson.getDoipGson().fromJson(new String(attrBytes), JsonObject.class);
            byte[] signature = MessageEnvelopeAggregator.readDataArray(bf);
            msg.credential = new MessageCredential(attrJo);
            msg.credential.setSignature(signature);
        }
        bf.release();
        return msg;
    }

    private static byte[] readDataArray(ByteBuf din) throws MessageCodecException {
        int dataLen = din.readInt();
        if (dataLen < 0 || dataLen > din.readableBytes()) {
            throw new MessageCodecException("invalid credential length");
        }
        byte[] data = new byte[dataLen];
        din.readBytes(data);
        return data;
    }
}

