/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.doip.endpoint.client;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import java.net.URI;
import java.net.URISyntaxException;
import org.bdware.doip.codec.DoipMessagePrinter;
import org.bdware.doip.codec.EncryptionTransmissionCodec;
import org.bdware.doip.codec.SignerCodec;
import org.bdware.doip.codec.doipMessage.DoipMessageSigner;
import org.bdware.doip.endpoint.CryptoManager;
import org.bdware.doip.endpoint.client.TLSClientConfig;

public class ClientConfig {
    public String url;
    public String protocolVersion;
    private boolean debugPrint;
    private transient DoipMessageSigner signer;
    private transient CryptoManager cryptoManager;

    public ClientConfig(String url) {
        this(url, "2.1");
    }

    public ClientConfig(String url, String protocolVersion) {
        this.url = url;
        this.protocolVersion = protocolVersion;
    }

    public ClientConfig setSigner(DoipMessageSigner signer) {
        this.signer = signer;
        return this;
    }

    public ClientConfig setCryptoManager(CryptoManager manager) {
        assert (this.signer != null);
        this.cryptoManager = manager;
        return this;
    }

    public ClientConfig setDebugPrint(boolean b) {
        this.debugPrint = b;
        return this;
    }

    public static ClientConfig fromUrl(String url) {
        return ClientConfig.fromUrl(url, "2.1");
    }

    public static ClientConfig fromUrl(String url, String protocolVersion) {
        URI uri = null;
        try {
            uri = new URI(url);
            if (uri.getScheme().toLowerCase().equals("tls")) {
                ClientConfig ret = TLSClientConfig.getDefault(url);
                ret.protocolVersion = protocolVersion;
                return ret;
            }
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        return new ClientConfig(url, protocolVersion);
    }

    public void addSignerAndEncryptionTransmission(ChannelPipeline pipline) {
        if (this.debugPrint) {
            pipline.addLast(new ChannelHandler[]{new DoipMessagePrinter()});
        }
        if (this.signer != null) {
            pipline.addLast(new ChannelHandler[]{new SignerCodec(this.signer)});
        }
        if (this.cryptoManager != null) {
            pipline.addLast(new ChannelHandler[]{new EncryptionTransmissionCodec(this.cryptoManager)});
        }
    }
}

