/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.doip.endpoint.server;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.nio.NioDatagramChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bdware.doip.codec.DatagramPacketToMessageEnvelopeCodec;
import org.bdware.doip.codec.MessageEnvelopeAggregator;
import org.bdware.doip.codec.MessageEnvelopePrinter;
import org.bdware.doip.endpoint.server.DoipListenerConfig;
import org.bdware.doip.endpoint.server.NettyDoipListener;

public class NettyUDPDoipListener
extends NettyDoipListener {
    private final int port;
    static Logger logger = LogManager.getLogger(NettyUDPDoipListener.class);
    private Channel ch;

    public NettyUDPDoipListener(int port, DoipListenerConfig config) throws Exception {
        this.port = port;
        this.listenerConfig = config;
    }

    @Override
    public void start() {
        if (this.handler == null) {
            logger.error("Handler not init yet! set handler first");
            return;
        }
        NioEventLoopGroup workerGroup = new NioEventLoopGroup();
        try {
            Bootstrap b = new Bootstrap();
            ((Bootstrap)((Bootstrap)((Bootstrap)b.group((EventLoopGroup)workerGroup)).channel(NioDatagramChannel.class)).localAddress(this.port)).option(ChannelOption.SO_BROADCAST, (Object)true);
            b.option(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)new WriteBufferWaterMark(0, 100));
            b.handler((ChannelHandler)new ChannelInitializer<DatagramChannel>(){

                protected void initChannel(DatagramChannel ch) throws Exception {
                    logger.info("establish a channel:" + NettyUDPDoipListener.this.port);
                    ch.pipeline().addLast(new ChannelHandler[]{new DatagramPacketToMessageEnvelopeCodec()}).addLast(new ChannelHandler[]{new MessageEnvelopePrinter()}).addLast(new ChannelHandler[]{new MessageEnvelopeAggregator(1468)});
                    NettyUDPDoipListener.this.listenerConfig.addExtraCodec(ch.pipeline());
                    ch.pipeline().addLast(new ChannelHandler[]{NettyUDPDoipListener.this.handler});
                }
            });
            this.ch = b.bind().syncUninterruptibly().channel();
            logger.info("UDP DOIP listener start at:" + this.port);
            this.ch.closeFuture().sync();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            workerGroup.shutdownGracefully();
        }
    }

    @Override
    public void stop() {
        this.ch.close();
    }
}

