/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.doip.endpoint.server;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslHandler;
import java.io.File;
import javax.net.ssl.SSLEngine;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bdware.doip.codec.MessageEnvelopeCodec;
import org.bdware.doip.codec.NaiveEnvelopeToDoMessage;
import org.bdware.doip.endpoint.server.NettyDoipListener;
import org.bdware.doip.endpoint.server.TLSListenerInfo;

public class NettyTLSDoipListener
extends NettyDoipListener {
    private final int port;
    static Logger logger = LogManager.getLogger(NettyTLSDoipListener.class);
    private Channel ch;
    SslContext sslContext;

    public NettyTLSDoipListener(int port, TLSListenerInfo listenerInfo) {
        this.port = port;
        this.listenerConfig = listenerInfo;
        if (!listenerInfo.getKeyFile().exists() || !listenerInfo.getChainKeyFile().exists()) {
            throw new IllegalStateException("missing key file or key chain file");
        }
        this.sslContext = this.getSSLContext(listenerInfo.getChainKeyFile(), listenerInfo.getKeyFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        if (this.handler == null) {
            logger.error("Handler not init yet! set handler first");
            return;
        }
        NioEventLoopGroup bossGroup = new NioEventLoopGroup(1);
        NioEventLoopGroup workerGroup = new NioEventLoopGroup();
        try {
            ServerBootstrap b = new ServerBootstrap();
            ((ServerBootstrap)b.group((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup).channel(NioServerSocketChannel.class)).localAddress(this.port);
            b.option(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)new WriteBufferWaterMark(0xA00000, 0x3200000));
            b.childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel ch) throws Exception {
                    SSLEngine engine = NettyTLSDoipListener.this.sslContext.newEngine(ch.alloc());
                    engine.setUseClientMode(false);
                    engine.setNeedClientAuth(false);
                    ch.pipeline().addFirst("ssl", (ChannelHandler)new SslHandler(engine)).addLast(new ChannelHandler[]{new LengthFieldBasedFrameDecoder(0x500000, 20, 4, 0, 0)}).addLast(new ChannelHandler[]{new MessageEnvelopeCodec()}).addLast(new ChannelHandler[]{new NaiveEnvelopeToDoMessage()}).addLast(new ChannelHandler[]{NettyTLSDoipListener.this.handler});
                }
            });
            this.ch = b.bind().syncUninterruptibly().channel();
            logger.info("TLS DOIP listener start at:" + this.port);
            this.ch.closeFuture().sync();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            bossGroup.shutdownGracefully();
        }
    }

    @Override
    public void stop() {
        this.ch.close();
    }

    protected SslContext getSSLContext(File chainFile, File keyFile) throws IllegalStateException {
        try {
            SslContext sslContext = SslContextBuilder.forServer((File)chainFile, (File)keyFile).ciphers(null, (ciphers, defaultCiphers, supportedCiphers) -> (String[])defaultCiphers.stream().filter(x -> null != x && !x.contains("RC4")).toArray(String[]::new)).build();
            return sslContext;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }
}

