/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.doip.codec;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageCodec;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bdware.doip.codec.doipMessage.DoipMessage;
import org.bdware.doip.codec.doipMessage.HeaderParameter;
import org.bdware.doip.codec.doipMessage.MessageCredential;
import org.bdware.doip.codec.doipMessage.MessageEnvelope;
import org.bdware.doip.codec.exception.MessageCodecException;
import org.bdware.doip.codec.utils.DoipGson;

public class NaiveEnvelopeToDoMessage
extends MessageToMessageCodec<MessageEnvelope, DoipMessage> {
    static Logger LOGGER = LogManager.getLogger(NaiveEnvelopeToDoMessage.class);

    protected void encode(ChannelHandlerContext ctx, DoipMessage msg, List<Object> out) throws Exception {
        this.messageToEnvelopes(msg, out);
    }

    public void messageToByteBuf(DoipMessage msg, ByteBuf out) throws MessageCodecException {
        msg.header.parameterLength = msg.header.parameters.length();
        msg.header.bodyLength = msg.body.getLength();
        out.writeInt(msg.header.getFlag());
        out.writeInt(msg.header.parameterLength);
        out.writeInt(msg.header.bodyLength);
        if (msg.header.parameterLength != 0 && msg.header.parameterLength != msg.header.parameters.length()) {
            throw new MessageCodecException("invalid parameter length: " + msg.header.parameterLength);
        }
        out.writeBytes(msg.header.parameters.toByteArray());
        if (msg.header.bodyLength != 0 && msg.header.bodyLength != msg.body.getLength()) {
            throw new MessageCodecException("invalid body length: " + msg.header.parameterLength);
        }
        out.writeBytes(msg.body.getEncodedData());
        if (msg.credential != null) {
            out.writeInt(msg.credential.attributeLength());
            out.writeBytes(DoipGson.getDoipGson().toJson((JsonElement)msg.credential.attributes).getBytes(StandardCharsets.UTF_8));
            out.writeInt(msg.credential.sigLength());
            out.writeBytes(msg.credential.getSignature());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageToEnvelopes(DoipMessage msg, List<Object> out) throws MessageCodecException {
        ByteBuf bf = Unpooled.directBuffer();
        try {
            this.messageToByteBuf(msg, bf);
            MessageEnvelope env = new MessageEnvelope();
            env.content = bf.retainedSlice(0, bf.writerIndex());
            env.setTruncated(false);
            env.setEncrypted(msg.header.isEncrypted());
            env.sequenceNumber = 0;
            env.totalNumber = 1;
            env.requestId = msg.requestID;
            env.contentLength = bf.writerIndex();
            out.add(env);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            bf.release();
        }
    }

    protected void decode(ChannelHandlerContext ctx, MessageEnvelope msg, List<Object> out) throws Exception {
        assert (msg.totalNumber == 1);
        out.add(this.byteBufToMessage(msg.content, msg.requestId));
        msg.content.release();
    }

    public DoipMessage byteBufToMessage(ByteBuf bf, int requestId) throws MessageCodecException {
        DoipMessage msg = new DoipMessage("", "");
        msg.requestID = requestId;
        msg.header.setFlag(bf.readInt());
        msg.header.parameterLength = bf.readInt();
        msg.header.bodyLength = bf.readInt();
        byte[] parameters = new byte[msg.header.parameterLength];
        bf.readBytes(parameters);
        msg.header.parameters = (HeaderParameter)DoipGson.getDoipGson().fromJson(new String(parameters, StandardCharsets.UTF_8), HeaderParameter.class);
        if (msg.header.bodyLength > 0) {
            if (bf.readableBytes() < msg.header.bodyLength) {
                throw new MessageCodecException("invalid body length");
            }
            msg.body.encodedData = new byte[msg.header.bodyLength];
            bf.readBytes(msg.body.encodedData);
        }
        if (bf.readableBytes() > 0) {
            byte[] attrBytes = NaiveEnvelopeToDoMessage.readDataArray(bf);
            JsonObject attrJo = (JsonObject)DoipGson.getDoipGson().fromJson(new String(attrBytes, StandardCharsets.UTF_8), JsonObject.class);
            byte[] signature = NaiveEnvelopeToDoMessage.readDataArray(bf);
            msg.credential = new MessageCredential(attrJo);
            msg.credential.setSignature(signature);
        }
        return msg;
    }

    private static byte[] readDataArray(ByteBuf din) throws MessageCodecException {
        int dataLen = din.readInt();
        if (dataLen < 0 || dataLen > din.readableBytes()) {
            throw new MessageCodecException("invalid credential length");
        }
        byte[] data = new byte[dataLen];
        din.readBytes(data);
        return data;
    }
}

