/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.doip.codec.doipMessage;

import com.google.gson.JsonElement;
import org.bdware.doip.codec.digitalObject.DigitalObject;
import org.bdware.doip.codec.doipMessage.DoipMessage;
import org.bdware.doip.codec.doipMessage.DoipResponseCode;

public class DoipMessageFactory {
    public static DoipMessage createTimeoutResponse(int requestID) {
        DoipMessage ret = new DoipMessage(null, null);
        ret.header.IsRequest = true;
        ret.header.parameters.response = DoipResponseCode.UnKnownError;
        ret.header.parameters.addAttribute("timeout", "timeout");
        ret.requestID = requestID;
        return ret;
    }

    public static DoipMessage createConnectFailedResponse(int requestID) {
        DoipMessage ret = new DoipMessage(null, null);
        ret.header.IsRequest = true;
        ret.header.parameters.response = DoipResponseCode.UnKnownError;
        ret.header.parameters.addAttribute("failed", "connect target doip service failed");
        ret.requestID = requestID;
        return ret;
    }

    public static class DoipMessageBuilder {
        DoipMessage ret;

        public DoipMessageBuilder createRequest(String targetID, String operation) {
            this.ret = new DoipMessage(targetID, operation);
            this.ret.header.setIsRequest(true);
            return this;
        }

        public DoipMessageBuilder createResponse(DoipResponseCode responseCode, DoipMessage reqMsg) {
            if (reqMsg == null) {
                this.ret = new DoipMessage(null, null, 0);
                return this;
            }
            this.ret = new DoipMessage(reqMsg.header.parameters.id, reqMsg.header.parameters.operation);
            this.ret.header.setIsRequest(false);
            this.ret.header.parameters = reqMsg.header.parameters.deepCopy();
            this.ret.header.parameters.response = responseCode;
            this.ret.requestID = reqMsg.requestID;
            this.ret.header.setIsCertified(reqMsg.header.isCertified());
            this.ret.header.setIsEncrypted(reqMsg.header.isEncrypted());
            if (reqMsg.credential != null && reqMsg.credential.getSigner() != null) {
                this.ret.setRecipientID(reqMsg.credential.getSigner());
            }
            return this;
        }

        public DoipMessageBuilder addAttributes(String key, JsonElement value) {
            this.ret.header.parameters.attributes.add(key, value);
            return this;
        }

        public DoipMessageBuilder addAttributes(String key, String value) {
            this.ret.header.parameters.addAttribute(key, value);
            return this;
        }

        public DoipMessageBuilder addAttributes(String key, int value) {
            this.ret.header.parameters.addAttribute(key, value);
            return this;
        }

        public DoipMessageBuilder setBody(byte[] body) {
            this.ret.body.encodedData = body;
            this.ret.header.bodyLength = this.ret.body.getLength();
            return this;
        }

        public DoipMessageBuilder setBody(DigitalObject digitalObject) {
            this.ret.body.setDataAsDigitalObject(digitalObject);
            return this;
        }

        public DoipMessage create() {
            return this.ret;
        }

        public DoipMessageBuilder setRequestID(int requestID) {
            this.ret.requestID = requestID;
            return this;
        }

        public DoipMessageBuilder setDoipMessage(DoipMessage message) {
            this.ret = message;
            return this;
        }
    }
}

