/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.doip.codec;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageCodec;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bdware.doip.codec.doipMessage.DoipMessage;
import org.bdware.doip.codec.doipMessage.DoipMessageSigner;

public class SignerCodec
extends MessageToMessageCodec<DoipMessage, DoipMessage> {
    DoipMessageSigner signer;
    static Logger LOGGER = LogManager.getLogger(SignerCodec.class);

    public SignerCodec(DoipMessageSigner signer) {
        this.signer = signer;
    }

    protected void encode(ChannelHandlerContext ctx, DoipMessage msg, List<Object> out) throws Exception {
        this.signer.signMessage(msg);
        out.add(msg);
    }

    protected void decode(ChannelHandlerContext ctx, DoipMessage msg, List<Object> out) throws Exception {
        if (!msg.header.isCertified()) {
            out.add(msg);
            return;
        }
        boolean verifyResult = this.signer.verifyMessage(msg);
        if (verifyResult) {
            out.add(msg);
        } else {
            LOGGER.error("verify Failed!! ignore msg!");
        }
    }
}

