/*
 *    Copyright (c) [2021] [Peking University]
 *    [BDWare DOIP SDK] is licensed under Mulan PSL v2.
 *    You can use this software according to the terms and conditions of the Mulan PSL v2.
 *    You may obtain a copy of Mulan PSL v2 at:
 *             http://license.coscl.org.cn/MulanPSL2
 *    THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT, MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 *    See the Mulan PSL v2 for more details.
 */

package org.bdware.doip.endpoint.event;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bdware.doip.codec.doipMessage.DoipMessage;
import org.bdware.doip.codec.doipMessage.DoipMessageFactory;
import org.bdware.doip.codec.doipMessage.DoipResponseCode;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;

public abstract class NaiveEventPool implements TopicHandler {
    static Logger logger = LogManager.getLogger(NaiveEventPool.class);
    EventBroker broker;

    public NaiveEventPool(EventBroker storage) {
        this.broker = storage;

    }

    @Override
    public DoipMessage handlePublish(DoipMessage request) {
        try {
            return broker.publish(request);
        } catch (Exception e) {
            ByteArrayOutputStream bo = new ByteArrayOutputStream();
            e.printStackTrace(new PrintStream(bo));
            DoipMessageFactory.DoipMessageBuilder builder = new DoipMessageFactory.DoipMessageBuilder();
            builder.createResponse(DoipResponseCode.UnKnownError, request);
            builder.setBody(bo.toByteArray());
            return builder.create();
        }
    }

    @Override
    public DoipMessage handleSubscribe(DoipMessage request) {
        try {
            String topicId = request.header.parameters.attributes.get("topicId").getAsString();
            String subscriberId = request.header.parameters.attributes.get("subscriberId").getAsString();
            boolean isSubscribe = request.header.parameters.attributes.has("subscribe")
                    && request.header.parameters.attributes.get("subscribe").getAsBoolean();
            if (isSubscribe)
                broker.subscribe(topicId, subscriberId);
            else
                broker.unsubscribe(topicId, subscriberId);
            DoipMessageFactory.DoipMessageBuilder builder = new DoipMessageFactory.DoipMessageBuilder();
            builder.createResponse(DoipResponseCode.Success, request);
            return builder.create();
        } catch (Exception e) {
            ByteArrayOutputStream bo = new ByteArrayOutputStream();
            e.printStackTrace(new PrintStream(bo));
            DoipMessageFactory.DoipMessageBuilder builder = new DoipMessageFactory.DoipMessageBuilder();
            builder.createResponse(DoipResponseCode.UnKnownError, request);
            builder.setBody(bo.toByteArray());
            return builder.create();
        }
    }
}
