/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.doip.endpoint.event;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bdware.doip.codec.doipMessage.DoipMessage;
import org.bdware.doip.codec.doipMessage.DoipMessageFactory;
import org.bdware.doip.codec.doipMessage.DoipResponseCode;
import org.bdware.doip.endpoint.event.EventBroker;
import org.bdware.doip.endpoint.event.TopicHandler;

public abstract class NaiveEventPool
implements TopicHandler {
    static Logger logger = LogManager.getLogger(NaiveEventPool.class);
    EventBroker broker;

    public NaiveEventPool(EventBroker storage) {
        this.broker = storage;
    }

    @Override
    public DoipMessage handlePublish(DoipMessage request) {
        try {
            return this.broker.publish(request);
        }
        catch (Exception e) {
            ByteArrayOutputStream bo = new ByteArrayOutputStream();
            e.printStackTrace(new PrintStream(bo));
            DoipMessageFactory.DoipMessageBuilder builder = new DoipMessageFactory.DoipMessageBuilder();
            builder.createResponse(DoipResponseCode.UnKnownError, request);
            builder.setBody(bo.toByteArray());
            return builder.create();
        }
    }

    @Override
    public DoipMessage handleSubscribe(DoipMessage request) {
        try {
            boolean isSubscribe;
            String topicId = request.header.parameters.attributes.get("topicId").getAsString();
            String subscriberId = request.header.parameters.attributes.get("subscriberId").getAsString();
            boolean bl = isSubscribe = request.header.parameters.attributes.has("subscribe") && request.header.parameters.attributes.get("subscribe").getAsBoolean();
            if (isSubscribe) {
                this.broker.subscribe(topicId, subscriberId);
            } else {
                this.broker.unsubscribe(topicId, subscriberId);
            }
            DoipMessageFactory.DoipMessageBuilder builder = new DoipMessageFactory.DoipMessageBuilder();
            builder.createResponse(DoipResponseCode.Success, request);
            return builder.create();
        }
        catch (Exception e) {
            ByteArrayOutputStream bo = new ByteArrayOutputStream();
            e.printStackTrace(new PrintStream(bo));
            DoipMessageFactory.DoipMessageBuilder builder = new DoipMessageFactory.DoipMessageBuilder();
            builder.createResponse(DoipResponseCode.UnKnownError, request);
            builder.setBody(bo.toByteArray());
            return builder.create();
        }
    }
}

