/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.doip.endpoint.server;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import org.bdware.doip.codec.DoipMessagePrinter;
import org.bdware.doip.codec.SignerCodec;
import org.bdware.doip.codec.doipMessage.DoipMessageSigner;
import org.bdware.doip.endpoint.CryptoManager;
import org.bdware.doip.endpoint.server.DoipRequestHandler;
import org.bdware.doip.endpoint.server.EncryptionTransmissionHandler;

public class DoipListenerConfig {
    public String url;
    public String protocolVersion;
    private transient DoipMessageSigner signer;
    private transient CryptoManager cryptoManager;
    private boolean debugPrint;

    public DoipListenerConfig(String url, String protocolVersion) {
        this.url = url;
        this.protocolVersion = protocolVersion;
    }

    public DoipListenerConfig setSigner(DoipMessageSigner signer) {
        assert (signer != null);
        this.signer = signer;
        return this;
    }

    public DoipListenerConfig setDebugPrint(boolean b) {
        this.debugPrint = b;
        return this;
    }

    public DoipListenerConfig setCryptoManager(CryptoManager cryptoManager) {
        assert (this.signer != null);
        assert (cryptoManager != null);
        this.cryptoManager = cryptoManager;
        return this;
    }

    public void addExtraCodec(ChannelPipeline pipline) {
        if (this.debugPrint) {
            pipline.addLast(new ChannelHandler[]{new DoipMessagePrinter()});
        }
        if (this.signer != null) {
            pipline.addLast(new ChannelHandler[]{new SignerCodec(this.signer)});
        }
    }

    public DoipRequestHandler wrapEncHandlerIfNeeded(DoipRequestHandler handler) {
        if (this.cryptoManager != null) {
            return new EncryptionTransmissionHandler(this.cryptoManager, handler);
        }
        return handler;
    }
}

