/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.doip.endpoint.client;

import java.net.URISyntaxException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bdware.doip.codec.digitalObject.DigitalObject;
import org.bdware.doip.codec.doipMessage.DoipMessage;
import org.bdware.doip.codec.doipMessage.DoipMessageFactory;
import org.bdware.doip.codec.exception.DoipConnectException;
import org.bdware.doip.codec.metadata.SearchParameter;
import org.bdware.doip.codec.operations.BasicOperations;
import org.bdware.doip.endpoint.EndpointFactory;
import org.bdware.doip.endpoint.client.ClientConfig;
import org.bdware.doip.endpoint.client.DoipClient;
import org.bdware.doip.endpoint.client.DoipClientChannel;
import org.bdware.doip.endpoint.client.DoipMessageCallback;

public class DoipClientImpl
implements DoipClient {
    DoipClientChannel doipChannel;
    String recipientID;
    String serverURL = null;
    Logger logger = LogManager.getLogger(DoipClientImpl.class);
    int timeoutSeconds = 5;

    @Override
    public void hello(String id, DoipMessageCallback cb) {
        DoipMessage msg = new DoipMessageFactory.DoipMessageBuilder().createRequest(id, BasicOperations.Hello.getName()).create();
        this.sendMessage(msg, cb);
    }

    @Override
    public void listOperations(String id, DoipMessageCallback cb) {
        DoipMessage msg = new DoipMessageFactory.DoipMessageBuilder().createRequest(id, BasicOperations.ListOps.getName()).create();
        this.sendMessage(msg, cb);
    }

    @Override
    public void retrieve(String id, String element, boolean includeElementData, DoipMessageCallback cb) {
        DoipMessage msg = new DoipMessageFactory.DoipMessageBuilder().createRequest(id, BasicOperations.Retrieve.getName()).create();
        if (element != null) {
            msg.header.parameters.addAttribute("element", element);
        }
        if (includeElementData) {
            msg.header.parameters.addAttribute("includeElementData", "true");
        }
        this.sendMessage(msg, cb);
    }

    @Override
    public void create(String targetDOIPServiceID, DigitalObject digitalObject, DoipMessageCallback cb) {
        DoipMessage msg = new DoipMessageFactory.DoipMessageBuilder().createRequest(targetDOIPServiceID, BasicOperations.Create.getName()).setBody(digitalObject).create();
        this.sendMessage(msg, cb);
    }

    @Override
    public void update(DigitalObject digitalObject, DoipMessageCallback cb) {
        DoipMessage msg = new DoipMessageFactory.DoipMessageBuilder().createRequest(digitalObject.id, BasicOperations.Update.getName()).setBody(digitalObject).create();
        this.sendMessage(msg, cb);
    }

    @Override
    public void delete(String id, DoipMessageCallback cb) {
        DoipMessage msg = new DoipMessageFactory.DoipMessageBuilder().createRequest(id, BasicOperations.Delete.getName()).create();
        this.sendMessage(msg, cb);
    }

    @Override
    public void search(String id, SearchParameter sp, DoipMessageCallback cb) {
        DoipMessage msg = new DoipMessageFactory.DoipMessageBuilder().createRequest(id, BasicOperations.Search.getName()).addAttributes("query", sp.query).addAttributes("pageNum", sp.pageNum).addAttributes("pageSize", sp.pageSize).addAttributes("type", sp.type).create();
        this.sendMessage(msg, cb);
    }

    @Override
    public void sendRawMessage(DoipMessage msg, DoipMessageCallback cb) {
        this.sendMessage(msg, cb);
    }

    @Override
    public void close() {
        this.doipChannel.close();
        this.doipChannel = null;
    }

    @Override
    public void connect(ClientConfig config) {
        try {
            this.serverURL = config.url;
            this.doipChannel = EndpointFactory.createDoipClientChannel(config);
            if (this.doipChannel == null) {
                return;
            }
            this.doipChannel.connect(this.serverURL);
            this.doipChannel.setTimeoutSecond(config.timeoutSeconds);
        }
        catch (URISyntaxException e) {
            this.logger.error("UUUUUURISyntaxException Exception!");
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            this.logger.error("IIIIInterruped Exception!");
            throw new RuntimeException(e);
        }
    }

    @Override
    public void reconnect() throws DoipConnectException {
        if (this.serverURL == null) {
            throw new DoipConnectException("target URL not set, use .connect(url) first");
        }
        ClientConfig clientConfig = ClientConfig.fromUrl(this.serverURL);
        if (this.doipChannel == null) {
            this.doipChannel = EndpointFactory.createDoipClientChannel(clientConfig);
        }
        if (this.doipChannel == null) {
            return;
        }
        try {
            this.doipChannel.connect(this.serverURL);
        }
        catch (InterruptedException | URISyntaxException e) {
            e.printStackTrace();
        }
    }

    public void reconnect(String url) throws DoipConnectException {
        this.serverURL = url;
        if (this.serverURL == null) {
            throw new DoipConnectException("target URL not set, use .connect(url) first");
        }
        ClientConfig clientConfig = ClientConfig.fromUrl(this.serverURL);
        if (this.doipChannel == null) {
            this.doipChannel = EndpointFactory.createDoipClientChannel(clientConfig);
        }
        if (this.doipChannel == null) {
            return;
        }
        try {
            this.doipChannel.connect(this.serverURL);
        }
        catch (InterruptedException | URISyntaxException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getRepoUrl() {
        return this.serverURL;
    }

    @Override
    public String getRecipientID() {
        return this.recipientID;
    }

    @Override
    public void setRecipientID(String id) {
        this.recipientID = id;
    }

    @Override
    public boolean isConnected() {
        return this.doipChannel != null && this.doipChannel.isConnected();
    }

    public void waitForConnected() {
        for (int i = 0; !(i >= 100 || this.doipChannel != null && this.doipChannel.isConnected()); ++i) {
            try {
                Thread.sleep(20L);
                continue;
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void sendMessage(DoipMessage msg, DoipMessageCallback cb) {
        if (this.doipChannel == null || !this.doipChannel.isConnected()) {
            this.logger.warn("channel not connect yet! " + (this.doipChannel == null) + " --> serverUrl:" + this.serverURL);
            DoipMessage resp = DoipMessageFactory.createConnectFailedResponse(msg.requestID);
            cb.onResult(resp);
            return;
        }
        msg.setRecipientID(this.recipientID);
        this.doipChannel.sendMessage(msg, cb);
    }
}

