/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.doip.endpoint.client;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.util.ArrayList;
import java.util.Random;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bdware.doip.codec.doipMessage.DoipMessage;
import org.bdware.doip.codec.doipMessage.DoipMessageFactory;
import org.bdware.doip.codec.doipMessage.DoipResponseCode;
import org.bdware.doip.endpoint.client.DoipMessageCallback;
import org.bdware.doip.endpoint.client.ResponseWait;

@ChannelHandler.Sharable
public class NettyDoipClientHandler
extends SimpleChannelInboundHandler<DoipMessage> {
    static Logger logger = LogManager.getLogger(NettyDoipClientHandler.class);
    public Channel channel;
    ResponseWait sync = new ResponseWait();
    Random random = new Random();

    public void sendMessage(DoipMessage request, DoipMessageCallback callback) {
        this.sendMessage(request, callback, 30);
    }

    public void sendMessage(DoipMessage request, DoipMessageCallback callback, int timeoutSeconds) {
        int i;
        if (callback == null) {
            logger.error("DoMessageCallback is null, please check!");
        }
        if (request.requestID == 0) {
            request.requestID = this.random.nextInt();
            for (i = 0; i < 5 && !this.sync.waitResponse(request.requestID, callback, timeoutSeconds); ++i) {
                request.requestID = this.random.nextInt();
                Thread.yield();
            }
        } else {
            while (i < 5 && !this.sync.waitResponse(request.requestID, callback, timeoutSeconds)) {
                request.requestID = this.random.nextInt();
                Thread.yield();
                ++i;
            }
        }
        if (i >= 5) {
            logger.error("waitObj.size() is too large! just Wait:" + request.requestID);
            DoipMessageFactory.DoipMessageBuilder builder = new DoipMessageFactory.DoipMessageBuilder();
            builder.createResponse(DoipResponseCode.MoreThanOneErrors, request);
            builder.addAttributes("msg", "waitObj.size too large!");
            callback.onResult(builder.create());
            return;
        }
        this.channel.writeAndFlush((Object)request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DoipMessage sendMessageSync(DoipMessage request, int timeoutSeconds) {
        final ArrayList ret = new ArrayList();
        DoipMessageCallback cb = new DoipMessageCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onResult(DoipMessage msg) {
                ret.add(msg);
                1 var2_2 = this;
                synchronized (var2_2) {
                    this.notify();
                }
            }
        };
        this.sendMessage(request, cb, timeoutSeconds);
        DoipMessageCallback doipMessageCallback = cb;
        synchronized (doipMessageCallback) {
            try {
                cb.wait(timeoutSeconds * 1000);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (ret.size() > 0) {
            return (DoipMessage)ret.get(0);
        }
        return DoipMessageFactory.createTimeoutResponse(request.requestID);
    }

    public void close() {
        this.channel.close();
    }

    public void setChannel(Channel c) {
        this.channel = c;
    }

    protected void channelRead0(ChannelHandlerContext ctx, DoipMessage msg) {
        logger.debug("channelRead0 receive a message");
        if (msg.header.parameters.attributes != null && msg.header.parameters.attributes.get("action") != null) {
            if (msg.header.parameters.attributes.get("action").getAsString().equals("start")) {
                this.sync.wakeup(msg.requestID, msg);
            } else {
                logger.debug("stop stream");
                this.sync.wakeUpAndRemove(msg.requestID, msg);
            }
        } else {
            this.sync.wakeUpAndRemove(msg.requestID, msg);
        }
    }
}

