/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.doip.endpoint.client;

import io.netty.util.HashedWheelTimer;
import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bdware.doip.codec.doipMessage.DoipMessage;
import org.bdware.doip.codec.doipMessage.DoipMessageFactory;
import org.bdware.doip.endpoint.client.DoipMessageCallback;

public class ResponseWait {
    static Logger LOGGER = LogManager.getLogger(ResponseWait.class);
    public static final HashedWheelTimer HASHED_WHEEL_TIMER = new HashedWheelTimer(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread t = Executors.defaultThreadFactory().newThread(r);
            t.setDaemon(true);
            return t;
        }
    }, 5L, TimeUnit.MILLISECONDS, 2);
    static final Map<Integer, Pair<DoipMessageCallback, Timeout>> waitObj = new ConcurrentHashMap<Integer, Pair<DoipMessageCallback, Timeout>>();

    public void wakeUpAndRemove(int requestID, DoipMessage result) {
        Pair<DoipMessageCallback, Timeout> ob = this.getAndRemove(requestID);
        this.wakeup(requestID, ob, result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Pair<DoipMessageCallback, Timeout> getAndRemove(int requestID) {
        Map<Integer, Pair<DoipMessageCallback, Timeout>> map = waitObj;
        synchronized (map) {
            Pair<DoipMessageCallback, Timeout> ob = waitObj.get(requestID);
            waitObj.remove(requestID);
            if (ob != null && ob.second != null) {
                ((Timeout)ob.second).cancel();
                return ob;
            }
            return null;
        }
    }

    public boolean waitResponseFor5Secs(int requestID, DoipMessageCallback cb) {
        return this.waitResponse(requestID, cb, 5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitResponse(final int requestID, DoipMessageCallback cb, int seconds) {
        if (waitObj.size() > 2000) {
            return false;
        }
        Map<Integer, Pair<DoipMessageCallback, Timeout>> map = waitObj;
        synchronized (map) {
            if (!waitObj.containsKey(requestID)) {
                TimerTask tt = new TimerTask(){

                    public void run(Timeout timeout) throws Exception {
                        DoipMessage timeOutMessage = DoipMessageFactory.createTimeoutResponse(requestID);
                        ResponseWait.this.wakeUpAndRemove(requestID, timeOutMessage);
                    }
                };
                Timeout timeout = HASHED_WHEEL_TIMER.newTimeout(tt, (long)seconds, TimeUnit.SECONDS);
                waitObj.put(requestID, new Pair<DoipMessageCallback, Timeout>(cb, timeout));
                return true;
            }
            LOGGER.debug("Return false, try again!");
            return false;
        }
    }

    public void wakeup(int requestID, DoipMessage result) {
        Pair<DoipMessageCallback, Timeout> ob = waitObj.get(requestID);
        this.wakeup(requestID, ob, result);
    }

    public void wakeup(int requestID, Pair<DoipMessageCallback, Timeout> ob, DoipMessage result) {
        if (ob == null) {
            // empty if block
        }
        if (ob != null) {
            ((DoipMessageCallback)ob.first).onResult(result);
            ((Timeout)ob.second).cancel();
        }
    }

    static class Pair<T, U> {
        final T first;
        final U second;

        Pair(T t, U u) {
            this.first = t;
            this.second = u;
        }
    }
}

