/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.doip.codec.doipMessage;

import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.net.InetSocketAddress;
import org.bdware.doip.codec.doipMessage.MessageBody;
import org.bdware.doip.codec.doipMessage.MessageCredential;
import org.bdware.doip.codec.doipMessage.MessageHeader;
import org.bdware.doip.codec.exception.MessageCodecException;

public class DoipMessage
implements Cloneable {
    public transient int requestID = 0;
    private transient String recipientID = null;
    public MessageHeader header;
    public MessageBody body;
    public MessageCredential credential;
    transient InetSocketAddress sender = null;

    public DoipMessage(String id, String opCode) {
        this.header = new MessageHeader(id, opCode);
        this.body = new MessageBody();
    }

    public DoipMessage(String id, String opCode, int flag) {
        this.header = new MessageHeader(id, opCode, flag);
        this.body = new MessageBody();
    }

    public boolean isRequest() {
        return this.header.isRequest();
    }

    public String getRecipientID() {
        return this.recipientID;
    }

    public void setRecipientID(String recipientID) {
        this.recipientID = recipientID;
    }

    public InetSocketAddress getSender() {
        return this.sender;
    }

    public void setSender(InetSocketAddress sender) {
        this.sender = sender;
    }

    public byte[] getDoipMessageHeaderBody() {
        try {
            ByteArrayOutputStream bo = new ByteArrayOutputStream();
            ObjectOutputStream oo = new ObjectOutputStream(bo);
            this.header.parameterLength = this.header.parameters.length();
            this.header.bodyLength = this.body.getLength();
            oo.writeInt(this.header.getFlag());
            oo.writeInt(this.header.parameterLength);
            oo.writeInt(this.header.bodyLength);
            if (this.header.parameterLength != 0 && this.header.parameterLength != this.header.parameters.length()) {
                throw new MessageCodecException("invalid parameter length: " + this.header.parameterLength);
            }
            oo.write(this.header.parameters.toByteArray());
            if (this.header.bodyLength != 0 && this.header.bodyLength != this.body.getLength()) {
                throw new MessageCodecException("invalid body length: " + this.header.parameterLength);
            }
            oo.write(this.body.getEncodedData());
            oo.close();
            return bo.toByteArray();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public DoipMessage clone() {
        try {
            return (DoipMessage)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }

    public DoipMessage withNewDOID(DoipMessage originalMessage, String newDOID) {
        DoipMessage clonedMsg = originalMessage.clone();
        clonedMsg.requestID = 0;
        clonedMsg.header = originalMessage.header.deepCopy();
        clonedMsg.header.parameters.id = newDOID;
        return clonedMsg;
    }
}

