/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.doip.codec.doipMessage;

import org.bdware.doip.codec.doipMessage.HeaderParameter;

public class MessageHeader {
    public boolean IsRequest;
    private int flag;
    public int parameterLength;
    public int bodyLength;
    public HeaderParameter parameters;
    private transient boolean isRequest = false;
    private transient boolean isCertified = false;
    private transient boolean isEncrypted = false;

    public MessageHeader(String id, String opCode) {
        this.flag = 0;
        this.parameters = new HeaderParameter(id, opCode);
        this.parameterLength = this.parameters.length();
    }

    public MessageHeader(String id, String opCode, int f) {
        this.setFlag(f);
        this.parameters = new HeaderParameter(id, opCode);
        this.parameterLength = this.parameters.length();
    }

    public MessageHeader() {
    }

    public MessageHeader deepCopy() {
        MessageHeader deepCopyMsgHeader = new MessageHeader();
        deepCopyMsgHeader.isRequest = this.isRequest;
        deepCopyMsgHeader.flag = this.flag;
        deepCopyMsgHeader.parameterLength = this.parameterLength;
        deepCopyMsgHeader.bodyLength = this.bodyLength;
        deepCopyMsgHeader.parameters = this.parameters.deepCopy();
        deepCopyMsgHeader.isRequest = this.isRequest;
        deepCopyMsgHeader.isCertified = this.isCertified;
        deepCopyMsgHeader.isEncrypted = this.isEncrypted;
        return deepCopyMsgHeader;
    }

    private boolean isRequest0() {
        return (this.flag & Integer.MIN_VALUE) != 0;
    }

    private boolean isCertified0() {
        return (this.flag & 0x40000000) != 0;
    }

    public boolean isRequest() {
        return this.isRequest;
    }

    public boolean isCertified() {
        return this.isCertified;
    }

    public boolean isEncrypted() {
        return this.isEncrypted;
    }

    public void setIsRequest(boolean isRequest) {
        this.isRequest = isRequest;
        this.updateFlag();
    }

    public void setIsEncrypted(boolean isEncrypted) {
        this.isEncrypted = isEncrypted;
    }

    public void setIsCertified(boolean isCertified) {
        this.isCertified = isCertified;
        this.updateFlag();
    }

    public void setFlag(int f) {
        this.flag = f;
        if (this.isRequest0()) {
            this.isRequest = true;
        }
        if (this.isCertified0()) {
            this.isCertified = true;
        }
    }

    public int getFlag() {
        return this.flag;
    }

    private void updateFlag() {
        this.flag = 0;
        if (this.isRequest) {
            this.flag |= Integer.MIN_VALUE;
        }
        if (this.isCertified) {
            this.flag |= 0x40000000;
        }
    }
}

