/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.doip.endpoint.client;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.bdware.doip.codec.MessageEnvelopeAggregator;
import org.bdware.doip.codec.MessageEnvelopeCodec;
import org.bdware.doip.endpoint.client.ClientConfig;
import org.bdware.doip.endpoint.client.NettyDoipClientChannel;
import org.bdware.doip.endpoint.client.NettyDoipClientHandler;

public class NettyDoipTCPClientChannel
extends NettyDoipClientChannel {
    Bootstrap b;
    static EventLoopGroup group;
    boolean splitEnvelop;
    int maxFrameLength;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NettyDoipTCPClientChannel(boolean splitEnvelop, final int maxFrameLength, final ClientConfig config) {
        this.splitEnvelop = splitEnvelop;
        this.maxFrameLength = maxFrameLength;
        this.handler = new NettyDoipClientHandler();
        Class<NettyDoipTCPClientChannel> clazz = NettyDoipTCPClientChannel.class;
        synchronized (NettyDoipTCPClientChannel.class) {
            if (group == null) {
                group = new NioEventLoopGroup(new ThreadFactory(){

                    @Override
                    public Thread newThread(Runnable r) {
                        Thread thread = Executors.defaultThreadFactory().newThread(r);
                        thread.setDaemon(true);
                        return thread;
                    }
                });
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            this.b = new Bootstrap();
            ((Bootstrap)((Bootstrap)((Bootstrap)this.b.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)5000)).option(ChannelOption.SO_KEEPALIVE, (Object)true)).option(ChannelOption.SO_REUSEADDR, (Object)true)).option(ChannelOption.SO_LINGER, (Object)0);
            this.b.option(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)new WriteBufferWaterMark(2 * maxFrameLength, 10 * maxFrameLength));
            this.b.group(group);
            ((Bootstrap)((Bootstrap)this.b.channel(NioSocketChannel.class)).option(ChannelOption.TCP_NODELAY, (Object)true)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel ch) {
                    ChannelPipeline p = ch.pipeline();
                    p.addLast(new ChannelHandler[]{new LengthFieldBasedFrameDecoder(maxFrameLength, 20, 4, 0, 0)}).addLast(new ChannelHandler[]{new MessageEnvelopeCodec()});
                    p.addLast(new ChannelHandler[]{new MessageEnvelopeAggregator(maxFrameLength - 24)});
                    config.addSignerAndEncryptionTransmission(p);
                    p.addLast(new ChannelHandler[]{NettyDoipTCPClientChannel.this.handler});
                }
            });
            return;
        }
    }

    public NettyDoipTCPClientChannel(ClientConfig config) {
        this(false, 0x500000, config);
    }

    @Override
    public void close() {
        try {
            this.channel.unsafe().closeForcibly();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.handler != null) {
            try {
                this.handler.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.isConnected = false;
    }

    @Override
    public void connect(String targetUrl) throws URISyntaxException, InterruptedException {
        URI uri = new URI(targetUrl);
        logger.debug("[URI Parse]scheme:" + uri.getScheme() + "  host: " + uri.getHost() + "  port: " + uri.getPort());
        logger.debug("[URI Parse]host: " + uri.getHost() + "  port: " + uri.getPort());
        this.channel = this.b.connect(uri.getHost(), uri.getPort()).sync().channel();
        this.handler.setChannel(this.channel);
        this.channel.config().setOption(ChannelOption.SO_LINGER, (Object)0);
        this.isConnected = true;
    }
}

