/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.doip.codec;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageCodec;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bdware.doip.codec.doipMessage.DoipMessage;
import org.bdware.doip.codec.doipMessage.MessageCredential;
import org.bdware.doip.endpoint.CryptoManager;

public class EncryptionTransmissionCodec<T, U>
extends MessageToMessageCodec<DoipMessage, DoipMessage> {
    static Logger LOGGER = LogManager.getLogger(EncryptionTransmissionCodec.class);
    CryptoManager<T, U> keyRetriever;

    public EncryptionTransmissionCodec(CryptoManager<T, U> manager) {
        this.keyRetriever = manager;
    }

    protected void encode(ChannelHandlerContext ctx, DoipMessage msg, List<Object> out) throws Exception {
        try {
            T pubkey = this.keyRetriever.getPublicKey(msg);
            U encryptedKey = this.keyRetriever.getSymmetricKey(msg);
            if (msg.body.getEncodedData() != null && msg.body.getEncodedData().length > 0) {
                byte[] encryptedBody = this.keyRetriever.encryptUseSymmetricKey(msg.body.getEncodedData(), encryptedKey);
                msg.body.encodedData = encryptedBody;
                String encryptedSymmetricKey = this.keyRetriever.encryptSymmetricKey(encryptedKey, pubkey);
                if (msg.credential == null) {
                    msg.credential = new MessageCredential((String)null);
                }
                msg.credential.setAttributes("encryptedSymmetricKey", encryptedSymmetricKey);
                msg.header.setIsEncrypted(true);
            }
            this.keyRetriever.putPubKeyToCredential(msg, this.keyRetriever.getOwnKeyPair(msg));
            out.add(msg);
        }
        catch (Exception e) {
            LOGGER.debug("Ignore encrypted failed message:" + e.getMessage());
            e.printStackTrace();
        }
    }

    protected void decode(ChannelHandlerContext ctx, DoipMessage msg, List<Object> out) throws Exception {
        try {
            if (!msg.header.isEncrypted()) {
                out.add(msg);
                return;
            }
            T mykey = this.keyRetriever.getOwnKeyPair(msg);
            String encryptedSymmetricKey = msg.credential.getAttriburte("encryptedSymmetricKey").getAsString();
            U symmetricKey = this.keyRetriever.decryptSymmetricKey(encryptedSymmetricKey, mykey);
            byte[] decyrpted = this.keyRetriever.decryptUseSymmetricKey(msg.body.getEncodedData(), symmetricKey);
            msg.body.encodedData = decyrpted;
            out.add(msg);
        }
        catch (Exception e) {
            LOGGER.debug("Ignore decrypt failed message:" + e.getMessage());
            e.printStackTrace();
        }
    }
}

