/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.doip.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import java.net.InetSocketAddress;
import java.util.Comparator;
import java.util.HashSet;
import java.util.PriorityQueue;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bdware.doip.codec.doipMessage.MessageEnvelope;

public class MessageEnvelopeBuffer {
    private PriorityQueue<MessageEnvelope> queue = new PriorityQueue<MessageEnvelope>(new Comparator<MessageEnvelope>(){

        @Override
        public int compare(MessageEnvelope o1, MessageEnvelope o2) {
            return o1.sequenceNumber - o2.sequenceNumber;
        }
    });
    private Set<Integer> toReceive;
    private InetSocketAddress sender;
    private static Logger LOGGER = LogManager.getLogger(MessageEnvelope.class);
    private long lastUpdate;

    public MessageEnvelopeBuffer(int requestId) {
    }

    public synchronized void add(MessageEnvelope msg) {
        this.lastUpdate = System.currentTimeMillis();
        if (this.toReceive == null) {
            this.toReceive = new HashSet<Integer>();
            for (int i = 0; i < msg.totalNumber; ++i) {
                this.toReceive.add(i);
            }
            this.sender = msg.getSender();
        }
        if (this.toReceive.contains(msg.sequenceNumber)) {
            this.queue.add(msg);
            this.toReceive.remove(msg.sequenceNumber);
        }
    }

    public ByteBuf toByteBuf() {
        CompositeByteBuf ret = Unpooled.compositeBuffer();
        int len = 0;
        while (!this.queue.isEmpty()) {
            len += this.queue.peek().contentLength;
            ret.addComponent(Unpooled.wrappedBuffer((ByteBuf)this.queue.poll().content));
        }
        ret.setIndex(0, len);
        return ret;
    }

    public boolean isComplete() {
        return this.queue.size() > 0 && this.queue.peek().totalNumber == this.queue.size();
    }

    public InetSocketAddress getSender() {
        return this.sender;
    }
}

