/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.doip.endpoint.server;

import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bdware.doip.endpoint.EndpointFactory;
import org.bdware.doip.endpoint.server.DoipListener;
import org.bdware.doip.endpoint.server.DoipListenerConfig;
import org.bdware.doip.endpoint.server.DoipRequestHandler;
import org.bdware.doip.endpoint.server.DoipServer;
import org.bdware.doip.endpoint.server.DoipServiceInfo;
import org.bdware.doip.endpoint.server.RepositoryHandler;
import org.bdware.doip.endpoint.server.RequestHandlerImpl;
import org.bdware.doip.endpoint.server.StartServerCallback;
import org.bdware.doip.endpoint.server.StartServerResultSender;

public class DoipServerImpl
implements DoipServer {
    static Logger logger = LogManager.getLogger(DoipServerImpl.class);
    List<DoipListener> listeners;
    protected DoipServiceInfo serviceInfo;
    List<ListenerContainer> containers;
    DoipRequestHandler requestCallback;

    public DoipServerImpl(DoipServiceInfo info) {
        this.serviceInfo = info;
        this.listeners = new ArrayList<DoipListener>();
        for (DoipListenerConfig lsnrInfo : info.listenerInfos) {
            DoipListener listener = EndpointFactory.createDoipListener(lsnrInfo);
            this.listeners.add(listener);
        }
        this.containers = new ArrayList<ListenerContainer>();
    }

    public static DoipServer createDoipServer(DoipServiceInfo info) {
        DoipServerImpl server = new DoipServerImpl(info);
        return server;
    }

    @Override
    public void start() {
        this.start(null);
    }

    public void start(StartServerCallback cb) {
        logger.info("DOIPServiceInfo: " + this.serviceInfo.toJson());
        for (DoipListener listener : this.listeners) {
            listener.setRequestHandler(this.requestCallback);
            if (listener instanceof StartServerResultSender && cb != null) {
                ((StartServerResultSender)((Object)listener)).setStartServerResultCallback(cb);
            }
            ListenerContainer container = new ListenerContainer(listener);
            this.containers.add(container);
            container.start();
        }
    }

    @Override
    public void stop() {
        logger.info("Try to stop listeners:");
        for (DoipListener listener : this.listeners) {
            listener.stop();
        }
        for (ListenerContainer c : this.containers) {
            c.interrupt();
        }
    }

    @Override
    public void setRepositoryHandler(RepositoryHandler handler) {
        this.requestCallback = new RequestHandlerImpl(handler);
    }

    public void setRequestCallback(DoipRequestHandler requestCallback) {
        this.requestCallback = requestCallback;
    }

    public DoipRequestHandler getRequestCallback() {
        return this.requestCallback;
    }

    public class ListenerContainer
    extends Thread {
        DoipListener listener;

        ListenerContainer(DoipListener l) {
            this.listener = l;
        }

        @Override
        public void run() {
            this.listener.start();
        }
    }
}

