/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.doip.codec;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageCodec;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bdware.doip.codec.doipMessage.MessageEnvelope;
import org.bdware.doip.codec.exception.MessageCodecException;

public class MessageEnvelopeCodec
extends ByteToMessageCodec<MessageEnvelope> {
    static Logger LOGGER = LogManager.getLogger(MessageEnvelopeCodec.class);

    protected void encode(ChannelHandlerContext ctx, MessageEnvelope msg, ByteBuf out) throws Exception {
        MessageEnvelopeCodec.envelopeToBytes(msg, out);
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        MessageEnvelope envelope = new MessageEnvelope();
        MessageEnvelopeCodec.byteBufToEnvelope(in, envelope);
        out.add(envelope);
    }

    public static void envelopeToBytes(MessageEnvelope envelope, ByteBuf bf) throws MessageCodecException {
        if (envelope.contentLength != envelope.content.readableBytes()) {
            throw new MessageCodecException("unequal content length");
        }
        bf.writeByte((int)envelope.majorVersion);
        bf.writeByte((int)envelope.minorVersion);
        bf.writeShort((int)envelope.getFlag());
        bf.writeInt(envelope.reserved);
        bf.writeInt(envelope.requestId);
        bf.writeInt(envelope.sequenceNumber);
        bf.writeInt(envelope.totalNumber);
        bf.writeInt(envelope.contentLength);
        bf.writeBytes(envelope.content);
        envelope.content.release();
    }

    public static void byteBufToEnvelope(ByteBuf bf, MessageEnvelope envelope) throws MessageCodecException {
        envelope.majorVersion = bf.readByte();
        envelope.minorVersion = bf.readByte();
        envelope.setFlag(bf.readShort());
        envelope.reserved = bf.readInt();
        envelope.requestId = bf.readInt();
        envelope.sequenceNumber = bf.readInt();
        envelope.totalNumber = bf.readInt();
        if (envelope.sequenceNumber > envelope.totalNumber) {
            throw new MessageCodecException("invalid sequence number: " + envelope.sequenceNumber + ", total: " + envelope.totalNumber);
        }
        envelope.contentLength = bf.readInt();
        if (envelope.contentLength != bf.readableBytes()) {
            throw new MessageCodecException("unequal content length: " + envelope.contentLength + ":" + bf.readableBytes());
        }
        envelope.content = bf.retainedSlice(bf.readerIndex(), bf.readableBytes());
        int readerIndex = bf.readerIndex() + bf.readableBytes();
        bf.setIndex(readerIndex, readerIndex);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        LOGGER.debug("got exception: " + cause.getMessage());
        cause.printStackTrace();
        if (ctx.channel().isActive()) {
            ctx.close();
        }
    }
}

