/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.doip.endpoint.client;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.util.concurrent.Future;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import org.bdware.doip.codec.DatagramPacketToMessageEnvelopeCodec;
import org.bdware.doip.codec.MessageEnvelopeAggregator;
import org.bdware.doip.codec.MessageEnvelopePrinter;
import org.bdware.doip.codec.SenderInjector;
import org.bdware.doip.endpoint.client.NettyDoipClientChannel;
import org.bdware.doip.endpoint.client.NettyDoipClientHandler;

public class NettyDoipUDPClientChannel
extends NettyDoipClientChannel {
    int clientPort;
    EventLoopGroup group;
    final Bootstrap b = new Bootstrap();

    public NettyDoipUDPClientChannel() throws URISyntaxException {
        this(0);
    }

    public NettyDoipUDPClientChannel(int cp) throws URISyntaxException {
        this.clientPort = cp;
    }

    @Override
    public void close() {
        this.remoteAddress = null;
        this.isConnected = false;
        if (this.handler != null) {
            this.handler.close();
        }
        if (this.group != null) {
            Future future = this.group.shutdownGracefully();
            future.syncUninterruptibly();
        }
    }

    @Override
    public void connect(String targetUrl) throws URISyntaxException, InterruptedException {
        final URI uri = new URI(targetUrl);
        if (this.group == null) {
            this.b.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)5000);
            this.b.option(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)new WriteBufferWaterMark(10, 100));
            this.group = new NioEventLoopGroup(10);
            this.b.group(this.group);
            this.handler = new NettyDoipClientHandler();
            ((Bootstrap)((Bootstrap)this.b.channel(NioDatagramChannel.class)).option(ChannelOption.SO_BROADCAST, (Object)true)).handler((ChannelHandler)new ChannelInitializer<DatagramChannel>(){

                protected void initChannel(DatagramChannel ch) {
                    ch.pipeline().addLast(new ChannelHandler[]{new DatagramPacketToMessageEnvelopeCodec(uri.getHost(), uri.getPort())}).addLast(new ChannelHandler[]{new SenderInjector(uri.getHost(), uri.getPort())}).addLast(new ChannelHandler[]{new MessageEnvelopePrinter()}).addLast(new ChannelHandler[]{new MessageEnvelopeAggregator(1468)}).addLast(new ChannelHandler[]{NettyDoipUDPClientChannel.this.handler});
                }
            });
        }
        this.remoteAddress = new InetSocketAddress(uri.getHost(), uri.getPort());
        this.channel = this.b.bind(this.clientPort).sync().channel();
        this.handler.setChannel(this.channel);
        this.isConnected = true;
    }
}

