/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.doip.endpoint.event;

import com.google.gson.JsonArray;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bdware.doip.codec.doipMessage.DoipMessage;
import org.bdware.doip.codec.doipMessage.DoipMessageFactory;
import org.bdware.doip.codec.doipMessage.DoipResponseCode;
import org.bdware.doip.endpoint.event.PublishMessageType;
import org.bdware.doip.endpoint.event.Publisher;
import org.bdware.doip.endpoint.event.SubscribeMessageType;
import org.bdware.doip.endpoint.event.Subscriber;
import org.bdware.doip.endpoint.event.TopicHandler;

public class EventMessageParser
implements TopicHandler {
    private static final Logger LOGGER = LogManager.getLogger(EventMessageParser.class);
    Publisher publisher;
    Subscriber subscriber;

    public EventMessageParser(Publisher publisher, Subscriber subscriber) {
        this.publisher = publisher;
        this.subscriber = subscriber;
    }

    @Override
    public DoipMessage handlePublish(DoipMessage request) {
        try {
            PublishMessageType publishType = PublishMessageType.valueOf(request.header.parameters.attributes.get("publishType").getAsString());
            String topicId = request.header.parameters.attributes.get("topicId").getAsString();
            String publisherId = request.header.parameters.attributes.get("publisherId").getAsString();
            if (publishType == null) {
                throw new IllegalArgumentException("missing argument: publishType");
            }
            if (request.header.parameters.attributes.has("merkelConfiguration")) {
                this.subscriber.receiveMerkelConfiguration(topicId, request.header.parameters.attributes.get("merkelConfiguration").getAsJsonObject(), request);
            }
            switch (publishType) {
                case Data: {
                    return this.subscriber.receiveData(topicId, publisherId, request);
                }
                case Hash: {
                    return this.subscriber.receiveHash(topicId, publisherId, request);
                }
                case DataAndHash: {
                    return this.subscriber.receiveDataAndHash(topicId, publisherId, request);
                }
            }
            throw new IllegalArgumentException("illegal argument: publishType");
        }
        catch (Exception e) {
            ByteArrayOutputStream bo = new ByteArrayOutputStream();
            e.printStackTrace(new PrintStream(bo));
            DoipMessageFactory.DoipMessageBuilder builder = new DoipMessageFactory.DoipMessageBuilder();
            builder.createResponse(DoipResponseCode.UnKnownError, request);
            builder.setBody(bo.toByteArray());
            return builder.create();
        }
    }

    @Override
    public DoipMessage handleSubscribe(DoipMessage request) {
        try {
            if (!request.header.parameters.attributes.has("topicId") || !request.header.parameters.attributes.has("subscriberId")) {
                throw new IllegalArgumentException("missing argument: topicId or subscriberId");
            }
            SubscribeMessageType subscribeType = SubscribeMessageType.valueOf(request.header.parameters.attributes.get("subscribeType").getAsString());
            if (subscribeType == null) {
                throw new IllegalArgumentException("missing argument: subscribeType");
            }
            String topicId = request.header.parameters.attributes.get("topicId").getAsString();
            String subscriberId = request.header.parameters.attributes.get("subscriberId").getAsString();
            long offset = 0L;
            long count = -1L;
            switch (subscribeType) {
                case Subscribe: {
                    boolean needReplay = request.header.parameters.attributes.has("needReplay") && request.header.parameters.attributes.get("needReplay").getAsBoolean();
                    return this.publisher.subscribe(topicId, subscriberId, needReplay, request);
                }
                case Unsubscribe: {
                    return this.publisher.unsubscribe(topicId, subscriberId, request);
                }
                case DataInList: {
                    JsonArray indexList = request.header.parameters.attributes.get("dataList").getAsJsonArray();
                    return this.publisher.sendDataInList(topicId, subscriberId, indexList, request);
                }
                case DataInRange: {
                    if (request.header.parameters.attributes.has("offset")) {
                        offset = request.header.parameters.attributes.get("offset").getAsLong();
                    }
                    if (request.header.parameters.attributes.has("count")) {
                        count = request.header.parameters.attributes.get("count").getAsLong();
                    }
                    return this.publisher.sendDataInRange(topicId, subscriberId, offset, count, request);
                }
                case VerifyMerkel: {
                    return this.publisher.verifyMerkelInRange(topicId, subscriberId, request);
                }
                case RequestMerkel: {
                    return this.publisher.sendMerkelInRange(topicId, subscriberId, request);
                }
            }
            throw new IllegalArgumentException("illegal argument: subscribeType");
        }
        catch (Exception e) {
            ByteArrayOutputStream bo = new ByteArrayOutputStream();
            e.printStackTrace(new PrintStream(bo));
            DoipMessageFactory.DoipMessageBuilder builder = new DoipMessageFactory.DoipMessageBuilder();
            builder.createResponse(DoipResponseCode.UnKnownError, request);
            builder.setBody(bo.toByteArray());
            return builder.create();
        }
    }
}

