/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.doip.codec.doipMessage;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.charset.StandardCharsets;
import org.bdware.doip.codec.doipMessage.DoipResponseCode;
import org.bdware.doip.codec.utils.DoipGson;

public class HeaderParameter {
    public String id;
    public String operation;
    public DoipResponseCode response;
    public JsonObject attributes;

    public HeaderParameter(String targetID, String operation) {
        this.id = targetID;
        this.operation = operation;
    }

    public HeaderParameter deepCopy() {
        HeaderParameter ret = new HeaderParameter(this.id, this.operation);
        if (this.attributes != null) {
            ret.attributes = this.attributes.deepCopy();
        }
        ret.response = this.response;
        return ret;
    }

    public int length() {
        return this.toByteArray().length;
    }

    public byte[] toByteArray() {
        return DoipGson.getDoipGson().toJson((Object)this).getBytes(StandardCharsets.UTF_8);
    }

    public void setResponse(DoipResponseCode response) {
        this.response = response;
    }

    public static HeaderParameter fromJson(String str) {
        return (HeaderParameter)DoipGson.getDoipGson().fromJson(str, HeaderParameter.class);
    }

    public void addAttribute(String key, String value) {
        if (this.attributes == null) {
            this.attributes = new JsonObject();
        }
        this.attributes.addProperty(key, value);
    }

    public void addAttribute(String key, long value) {
        if (this.attributes == null) {
            this.attributes = new JsonObject();
        }
        this.attributes.addProperty(key, (Number)value);
    }

    public void addAttribute(String key, int value) {
        if (this.attributes == null) {
            this.attributes = new JsonObject();
        }
        this.attributes.addProperty(key, (Number)value);
    }

    public void addAttribute(String key, boolean value) {
        if (this.attributes == null) {
            this.attributes = new JsonObject();
        }
        this.attributes.addProperty(key, Boolean.valueOf(value));
    }

    public void addAttribute(String key, JsonElement value) {
        if (this.attributes == null) {
            this.attributes = new JsonObject();
        }
        this.attributes.add(key, value);
    }
}

