/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.doip.endpoint.client;

import io.netty.util.HashedWheelTimer;
import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bdware.doip.codec.doipMessage.DoipMessage;
import org.bdware.doip.codec.doipMessage.DoipMessageFactory;
import org.bdware.doip.endpoint.client.DoipMessageCallback;

public class ResponseWait {
    static Logger LOGGER = LogManager.getLogger(ResponseWait.class);
    public static final HashedWheelTimer HASHED_WHEEL_TIMER = new HashedWheelTimer(r -> {
        Thread t = Executors.defaultThreadFactory().newThread(r);
        t.setDaemon(true);
        return t;
    }, 5L, TimeUnit.MILLISECONDS, 2);
    static final Map<Integer, Pair<DoipMessageCallback, Timeout>> waitObj = new ConcurrentHashMap<Integer, Pair<DoipMessageCallback, Timeout>>();
    static AtomicInteger total = new AtomicInteger(0);

    public void wakeUpAndRemove(int requestID, DoipMessage result) {
        Pair<DoipMessageCallback, Timeout> ob = this.getAndRemove(requestID);
        this.wakeup(ob, result);
    }

    private Pair<DoipMessageCallback, Timeout> getAndRemove(int requestID) {
        Pair<DoipMessageCallback, Timeout> ob = waitObj.remove(requestID);
        if (ob != null && ob.second != null) {
            ((Timeout)ob.second).cancel();
            return ob;
        }
        return null;
    }

    public boolean waitResponseFor5Secs(int requestID, DoipMessageCallback cb) {
        return this.waitResponse(requestID, cb, 5);
    }

    public boolean waitResponse(int requestID, DoipMessageCallback cb, int seconds) {
        TimerTask tt = timeout -> {
            DoipMessage timeOutMessage = DoipMessageFactory.createTimeoutResponse(requestID, "[ResponseWait.waitResponse]");
            this.wakeUpAndRemove(requestID, timeOutMessage);
        };
        Timeout timeout2 = HASHED_WHEEL_TIMER.newTimeout(tt, (long)seconds, TimeUnit.SECONDS);
        Pair<DoipMessageCallback, Timeout> value = new Pair<DoipMessageCallback, Timeout>(cb, timeout2);
        Pair<DoipMessageCallback, Timeout> oldValue = waitObj.putIfAbsent(requestID, value);
        if (oldValue == null) {
            return true;
        }
        LOGGER.debug("Response Wait \u8fd4\u56defalse\uff0c\u518d\u6b21\u5c1d\u8bd5\uff01");
        timeout2.cancel();
        return false;
    }

    public void wakeup(int requestID, DoipMessage result) {
        Pair<DoipMessageCallback, Timeout> ob = waitObj.get(requestID);
        this.wakeup(ob, result);
    }

    public void wakeup(Pair<DoipMessageCallback, Timeout> ob, DoipMessage result) {
        if (ob != null) {
            ((Timeout)ob.second).cancel();
            ((DoipMessageCallback)ob.first).onResult(result);
        }
    }

    public static class Pair<T, U> {
        final T first;
        final U second;

        Pair(T t, U u) {
            this.first = t;
            this.second = u;
        }
    }
}

