package org.bdware.doip.codec.v3;

import io.netty.buffer.ByteBuf;
import org.bdware.doip.codec.v3.headers.*;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 *  针对扩展类型，要求定义一个类继承了extension part。同时要求：
 *  1）public static int EXTENSION_CODE，与其他头不冲突。
 *  2）具有一个构造函数，参数为ByteBuf。
 *  当前ExtensionCode=1,2,3,4的类分别为DOLHeader EnvelopeWrapper VDNHeader ExceptionHead
 * */
public class ExtensionPartFactory {
    static Map<Integer, Class<? extends ExtensionPart>> registedParts = new ConcurrentHashMap<>();

    static {
        Class<? extends ExtensionPart>[] clzs = new Class[]{DOLHeader.class, EnvelopeWrapper.class, VDNHeader.class,
                ExceptionHead.class};
        for (Class clz : clzs) {
            register(clz);
        }
    }

    public static void register(Class<? extends ExtensionPart> clz) {
        try {
            Field f = clz.getDeclaredField("EXTENSION_CODE");
            f.setAccessible(true);
            int code = f.getInt(null);
            if (registedParts.containsKey(code)) throw new IllegalStateException("redefined Extension Code");
            registedParts.put(code, clz);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static ExtensionPart parse(int headOp, ByteBuf bf) {
        try {
            Class<? extends ExtensionPart> clz = registedParts.get(headOp);
            Constructor<? extends ExtensionPart> constructor = null;
            constructor = clz.getDeclaredConstructor(ByteBuf.class);
            ExtensionPart part = constructor.newInstance(bf);
            return part;
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}
