package org.bdware.doip.codec.v3;

import org.bdware.doip.codec.v3.headers.ExceptionHead;

import java.nio.charset.StandardCharsets;

public class V3MsgFactory implements TimeoutMsgFactory<DOIPV3Message> {
    @Override
    public DOIPV3Message createTimoutMessage(long requestId, DOIPV3Message request, long timeout, String msg) {
        DOIPV3Message message = new DOIPV3Message();
        message.requestID = requestId;
        ExceptionHead exception = new ExceptionHead();
        exception.code = 2;
        exception.setContent(msg.getBytes(StandardCharsets.UTF_8));
        message.appendPart(exception);
        return message;
    }

    public DOIPV3Message createErrorMessage(long requestId, String msg) {
        DOIPV3Message message = new DOIPV3Message();
        message.requestID = requestId;
        ExceptionHead exception = new ExceptionHead();
        exception.code = 3;
        exception.setContent(msg.getBytes(StandardCharsets.UTF_8));
        message.appendPart(exception);
        return message;
    }
}