package org.bdware.doip.codec.v3.headers;

import io.netty.buffer.ByteBuf;

public class ExceptionHead extends ExtensionPart {
    public static final int EXTENSION_CODE = 4;

    //locateFlag=0 需要交换机定位，向其他交换机转发。
    //locateFlag=1 表示就是这个交换机了，需要交换机向空间转发。
    public int code;
    private int contentLength;
    private byte[] content;

    public ExceptionHead(ByteBuf bf) {
        super();
        nextType = bf.readInt();
        code = bf.readInt();
        contentLength = bf.readInt();
        if (contentLength > 0) {
            content = new byte[contentLength];
            bf.readBytes(content);
        }
    }

    public ExceptionHead() {

    }

    public void setContent(byte[] newDol) {
        if (newDol == null) contentLength = 0;
        else {
            this.content = newDol;
            this.contentLength = content.length;
        }
    }

    @Override
    public void writeTo(ByteBuf bf) {
        //keep the correctness of nextType
        bf.writeInt(nextType);
        bf.writeInt(code);
        if (content != null && content.length > 0) {
            bf.writeInt(content.length);
            bf.writeBytes(content);
        } else bf.writeInt(0);
    }

    @Override
    public int length() {
        return 1 + 4 + 4 + ((content == null) ? 0 : content.length);
    }

    @Override
    public int getType() {
        return EXTENSION_CODE;
    }

    @Override
    public String prettyPrint() {
        return "ExceptionHead code:" + code + " content:" + new String(content);
    }
}
