/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.doip.codec.v3;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageCodec;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bdware.doip.codec.MessageEnvelopeCodec;
import org.bdware.doip.codec.doipMessage.MessageEnvelope;
import org.bdware.doip.codec.v3.DOIPV3Codec;
import org.bdware.doip.codec.v3.DOIPV3Handler;
import org.bdware.doip.codec.v3.DOIPV3Message;

public class DOIPCodec
extends ByteToMessageCodec<Object> {
    static Logger LOGGER = LogManager.getLogger(DOIPV3Message.class);

    protected void encode(ChannelHandlerContext ctx, Object msg, ByteBuf out) throws Exception {
        if (msg instanceof MessageEnvelope) {
            LOGGER.info("switch to doipv2");
            ctx.pipeline().replace((ChannelHandler)this, "DOIPV2Codec", (ChannelHandler)new MessageEnvelopeCodec());
            MessageEnvelopeCodec.envelopeToBytes((MessageEnvelope)msg, out);
        } else if (msg instanceof DOIPV3Message) {
            LOGGER.info("switch to doipv3");
            DOIPV3Codec target = new DOIPV3Codec();
            ctx.pipeline().replace((ChannelHandler)this, "DOIPV3Codec", (ChannelHandler)target);
            target.encode(ctx, (DOIPV3Message)msg, out);
        }
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        LOGGER.info("try to switch protocol");
        int pos = in.readerIndex();
        byte majorVersion = in.readByte();
        if (majorVersion == 3) {
            in.readerIndex(pos);
            ctx.pipeline().replace((ChannelHandler)this, "DOIPV3Codec", (ChannelHandler)new DOIPV3Codec());
        } else if (majorVersion == 2) {
            ctx.pipeline().remove(DOIPV3Handler.class);
            in.readerIndex(pos);
            ctx.pipeline().replace((ChannelHandler)this, "DOIPV2Codec", (ChannelHandler)new MessageEnvelopeCodec());
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        LOGGER.debug("DOIPV3Codec got exception: " + cause.getMessage());
        cause.printStackTrace();
    }
}

