/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.doip.codec.v3;

import io.netty.buffer.ByteBuf;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bdware.doip.codec.v3.headers.DOLHeader;
import org.bdware.doip.codec.v3.headers.EnvelopeWrapper;
import org.bdware.doip.codec.v3.headers.ExceptionHead;
import org.bdware.doip.codec.v3.headers.ExtensionPart;
import org.bdware.doip.codec.v3.headers.VDNHeader;

public class ExtensionPartFactory {
    static Map<Integer, Class<? extends ExtensionPart>> registedParts;

    public static void register(Class<? extends ExtensionPart> clz) {
        try {
            Field f = clz.getDeclaredField("EXTENSION_CODE");
            f.setAccessible(true);
            int code = f.getInt(null);
            if (registedParts.containsKey(code)) {
                throw new IllegalStateException("redefined Extension Code");
            }
            registedParts.put(code, clz);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static ExtensionPart parse(int headOp, ByteBuf bf) {
        try {
            Class<? extends ExtensionPart> clz = registedParts.get(headOp);
            Constructor<? extends ExtensionPart> constructor = null;
            constructor = clz.getDeclaredConstructor(ByteBuf.class);
            ExtensionPart part = constructor.newInstance(bf);
            return part;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        Class[] clzs;
        registedParts = new ConcurrentHashMap<Integer, Class<? extends ExtensionPart>>();
        for (Class clz : clzs = new Class[]{DOLHeader.class, EnvelopeWrapper.class, VDNHeader.class, ExceptionHead.class}) {
            ExtensionPartFactory.register(clz);
        }
    }
}

