/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.doip.codec.v3.headers;

import io.netty.buffer.ByteBuf;
import org.bdware.doip.codec.v3.headers.ExtensionPart;

public class ExceptionHead
extends ExtensionPart {
    public static final int EXTENSION_CODE = 4;
    public int code;
    private int contentLength;
    private byte[] content;

    public ExceptionHead(ByteBuf bf) {
        this.nextType = bf.readInt();
        this.code = bf.readInt();
        this.contentLength = bf.readInt();
        if (this.contentLength > 0) {
            this.content = new byte[this.contentLength];
            bf.readBytes(this.content);
        }
    }

    public ExceptionHead() {
    }

    public void setContent(byte[] newDol) {
        if (newDol == null) {
            this.contentLength = 0;
        } else {
            this.content = newDol;
            this.contentLength = this.content.length;
        }
    }

    @Override
    public void writeTo(ByteBuf bf) {
        bf.writeInt(this.nextType);
        bf.writeInt(this.code);
        if (this.content != null && this.content.length > 0) {
            bf.writeInt(this.content.length);
            bf.writeBytes(this.content);
        } else {
            bf.writeInt(0);
        }
    }

    @Override
    public int length() {
        return 9 + (this.content == null ? 0 : this.content.length);
    }

    @Override
    public int getType() {
        return 4;
    }

    @Override
    public String prettyPrint() {
        return "ExceptionHead code:" + this.code + " content:" + new String(this.content);
    }
}

