/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.doip.endpoint.server.v3;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bdware.doip.endpoint.server.DoipListenerConfig;
import org.bdware.doip.endpoint.server.DoipServiceInfo;
import org.bdware.doip.endpoint.server.StartServerCallback;
import org.bdware.doip.endpoint.server.StartServerResultSender;
import org.bdware.doip.endpoint.server.v3.RequestHandler;
import org.bdware.doip.endpoint.server.v3.TCPListener;

public class Server {
    static Logger logger = LogManager.getLogger(Server.class);
    List<TCPListener> listeners;
    protected DoipServiceInfo serviceInfo;
    List<ListenerContainer> containers;
    RequestHandler requestCallback;

    public Server(DoipServiceInfo info) {
        this.serviceInfo = info;
        this.listeners = new ArrayList<TCPListener>();
        for (DoipListenerConfig lsnrInfo : info.listenerInfos) {
            URI url = null;
            try {
                url = new URI(lsnrInfo.url);
                TCPListener listener = new TCPListener(url.getPort(), lsnrInfo);
                this.listeners.add(listener);
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
        this.containers = new ArrayList<ListenerContainer>();
    }

    public void start() {
        this.start(null);
    }

    public void start(StartServerCallback cb) {
        logger.info("DOIPServiceInfo: " + this.serviceInfo.toJson());
        for (TCPListener listener : this.listeners) {
            listener.setRequestHandler(this.requestCallback);
            if (listener instanceof StartServerResultSender && cb != null) {
                ((StartServerResultSender)((Object)listener)).setStartServerResultCallback(cb);
            }
            ListenerContainer container = new ListenerContainer(listener);
            this.containers.add(container);
            container.start();
        }
    }

    public void stop() {
        logger.info("Try to stop listeners:");
        for (TCPListener listener : this.listeners) {
            listener.stop();
        }
        for (ListenerContainer c : this.containers) {
            c.interrupt();
        }
    }

    public void setRequestCallback(RequestHandler requestCallback) {
        this.requestCallback = requestCallback;
    }

    public RequestHandler getRequestCallback() {
        return this.requestCallback;
    }

    public class ListenerContainer
    extends Thread {
        TCPListener listener;

        ListenerContainer(TCPListener l) {
            this.listener = l;
        }

        @Override
        public void run() {
            this.listener.start();
        }
    }
}

