package org.bdware.doip.codec.v3;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageCodec;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bdware.doip.codec.MessageEnvelopeCodec;
import org.bdware.doip.codec.doipMessage.MessageEnvelope;

import java.util.List;

// Byte To MessageEnvelope(DoipV2.1) or DoipV3Message
// Support DOIPV2.1 & DOIPV3 Encoding and Decoding.
public class DOIPCodec extends ByteToMessageCodec<Object> {

    static Logger LOGGER = LogManager.getLogger(DOIPV3Message.class);

    @Override
    protected void encode(ChannelHandlerContext ctx, Object msg, ByteBuf out) throws Exception {
        if (msg instanceof MessageEnvelope) {
            LOGGER.info("switch to doipv2");
            ctx.pipeline().replace(this, "DOIPV2Codec", new MessageEnvelopeCodec());
            MessageEnvelopeCodec.envelopeToBytes((MessageEnvelope) msg, out);
        } else if (msg instanceof DOIPV3Message) {
            LOGGER.info("switch to doipv3");
            DOIPV3Codec target = new DOIPV3Codec();
            ctx.pipeline().replace(this, "DOIPV3Codec", target);
            target.encode(ctx, (DOIPV3Message) msg, out);
        }
        //never used
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        LOGGER.info("try to switch protocol");
        int pos = in.readerIndex();
        byte majorVersion = in.readByte();
        if (majorVersion == 3) {
            in.readerIndex(pos);
            //把ctx里的pipline保留，把自己替换为DOIPV3Codec即可。
            ctx.pipeline().replace(this, "DOIPV3Codec", new DOIPV3Codec());
        } else if (majorVersion == 2) {
            //把ctx里的pipline和DOIPV3Codec相关的删除。
            ctx.pipeline().remove(DOIPV3Handler.class);
            //把自己删除即可。
            in.readerIndex(pos);
            ctx.pipeline().replace(this, "DOIPV2Codec", new MessageEnvelopeCodec());
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        LOGGER.debug("DOIPV3Codec got exception: " + cause.getMessage());
        cause.printStackTrace();
    }
}
