/*
 *    Copyright (c) [2021] [Peking University]
 *    [BDWare DOIP SDK] is licensed under Mulan PSL v2.
 *    You can use this software according to the terms and conditions of the Mulan PSL v2.
 *    You may obtain a copy of Mulan PSL v2 at:
 *             http://license.coscl.org.cn/MulanPSL2
 *    THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT, MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 *    See the Mulan PSL v2 for more details.
 */

package org.bdware.doip.codec.v3;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageCodec;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import java.util.List;

public class DOIPV3Printer extends MessageToMessageCodec<DOIPV3Message, DOIPV3Message> {
    static Logger LOGGER = LogManager.getLogger(DOIPV3Printer.class);

    @Override
    protected void encode(ChannelHandlerContext ctx, DOIPV3Message msg, List<Object> out) throws Exception {
        msg.fixNextHeaderAndCalculateContentLength();
        LOGGER.info("[SEND V3] " + msg.prettyPrint() + " to:" + ctx.channel().remoteAddress().toString());
        out.add(msg);
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, DOIPV3Message msg, List<Object> out) throws Exception {
        LOGGER.info("[RECV V3] " + msg.prettyPrint() + " from:" + ctx.channel().remoteAddress().toString());
        out.add(msg);
    }
}
