package org.bdware.doip.codec.v3.headers;

import io.netty.buffer.ByteBuf;

public class VDNHeader extends ExtensionPart {

    public static final int EXTENSION_CODE = 3;

    //locateFlag=0 需要交换机定位，向其他交换机转发。
    //locateFlag=1 表示就是这个交换机了，需要交换机向空间转发。
    public byte locateFlag;
    public long sourceId;
    public long destinationId;
    public static final int LENGTH = 4 + 1 + 8 + 8;

    public VDNHeader(ByteBuf bf) {
        super();
        nextType = bf.readInt();
        locateFlag = bf.readByte();
        sourceId = bf.readLong();
        destinationId = bf.readLong();
    }

    public VDNHeader() {
        nextType = locateFlag = 0;
        sourceId = destinationId = 0;
    }

    @Override
    public void writeTo(ByteBuf bf) {
        //keep the correctness of nextType
        bf.writeInt(nextType);
        bf.writeByte(locateFlag);
        bf.writeLong(sourceId);
        bf.writeLong(destinationId);
    }

    @Override
    public int length() {
        return LENGTH;
    }

    @Override
    public int getType() {
        return EXTENSION_CODE;
    }

    @Override
    public String prettyPrint() {
        return "VDNHeader locateFlag:" + ((int) locateFlag) + " " + sourceId + " " + destinationId;
    }
}
