/*
 *    Copyright (c) [2021] [Peking University]
 *    [BDWare DOIP SDK] is licensed under Mulan PSL v2.
 *    You can use this software according to the terms and conditions of the Mulan PSL v2.
 *    You may obtain a copy of Mulan PSL v2 at:
 *             http://license.coscl.org.cn/MulanPSL2
 *    THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT, MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 *    See the Mulan PSL v2 for more details.
 */

package org.bdware.doip.endpoint.server.v3;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bdware.doip.endpoint.server.DoipListenerConfig;
import org.bdware.doip.endpoint.server.DoipServiceInfo;
import org.bdware.doip.endpoint.server.StartServerCallback;
import org.bdware.doip.endpoint.server.StartServerResultSender;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;

public class Server {
    static Logger logger = LogManager.getLogger(Server.class);

    List<TCPListener> listeners;
    protected DoipServiceInfo serviceInfo;
    List<ListenerContainer> containers;
    RequestHandler requestCallback;

    public Server(DoipServiceInfo info) {
        this.serviceInfo = info;
        listeners = new ArrayList<>();
        for (DoipListenerConfig lsnrInfo : info.listenerInfos) {
            URI url = null;
            try {
                url = new URI(lsnrInfo.url);
                TCPListener listener = new TCPListener(url.getPort(), lsnrInfo);
                listeners.add(listener);
            } catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
        containers = new ArrayList<>();
    }


    public void start() {
        start(null);
    }

    public void start(StartServerCallback cb) {
        logger.info("DOIPServiceInfo: " + serviceInfo.toJson());
        for (TCPListener listener : listeners) {
            listener.setRequestHandler(requestCallback);
            if (listener instanceof StartServerResultSender && cb != null) {
                ((StartServerResultSender) listener).setStartServerResultCallback(cb);
            }
            ListenerContainer container = new ListenerContainer(listener);
            containers.add(container);
            container.start();
        }
    }


    public void stop() {
        logger.info("Try to stop listeners:");
        for (TCPListener listener : listeners) {
            listener.stop();
        }
        for (ListenerContainer c : containers) {
            c.interrupt();
        }
    }

    public void setRequestCallback(RequestHandler requestCallback) {
        this.requestCallback = requestCallback;
    }

    public RequestHandler getRequestCallback() {
        return this.requestCallback;
    }

    public class ListenerContainer extends Thread {
        TCPListener listener;

        ListenerContainer(TCPListener l) {
            this.listener = l;
        }

        @Override
        public void run() {
            listener.start();
        }
    }

}
