/*
 *    Copyright (c) [2021] [Peking University]
 *    [BDWare DOIP SDK] is licensed under Mulan PSL v2.
 *    You can use this software according to the terms and conditions of the Mulan PSL v2.
 *    You may obtain a copy of Mulan PSL v2 at:
 *             http://license.coscl.org.cn/MulanPSL2
 *    THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT, MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 *    See the Mulan PSL v2 for more details.
 */

package org.bdware.doip.endpoint.server.v3;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bdware.doip.codec.v3.DOIPV3Message;
import org.bdware.doip.codec.v3.V3MsgFactory;
import org.bdware.doip.endpoint.client.v3.MessageCallback;
import org.bdware.doip.endpoint.server.DoipListenerConfig;

@ChannelHandler.Sharable
public class ServerHandler extends SimpleChannelInboundHandler<DOIPV3Message> {
    static Logger logger = LogManager.getLogger(ServerHandler.class);
    protected RequestHandler requestHandler;
    V3MsgFactory factory = new V3MsgFactory();

    public ServerHandler(RequestHandler handler, DoipListenerConfig listenerConfig) {
        this.requestHandler = handler;
    }

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, DOIPV3Message msg) {
        //logger.debug("receive a message: " + new Gson().toJson(msg.header));
        if (msg.requestID == 0) {
            replyErrorString(ctx, msg, "invalid requestID");
            return;
        }
        requestHandler.handle(ctx, msg, new MessageCallback<DOIPV3Message>() {
            @Override
            public void onResult(DOIPV3Message result) {
                assert result.requestID == msg.requestID;
                ctx.writeAndFlush(result);
            }
        });
    }


    @Override
    public void channelActive(ChannelHandlerContext ctx) {
//        logger.debug("channel active");

    }

    public void defaultHandler(ChannelHandlerContext ctx, DOIPV3Message request) {
        replyErrorString(ctx, request, "Unsupported Operation!");
    }

    protected void replyErrorString(ChannelHandlerContext ctx, DOIPV3Message request, String str) {
        sendResponse(ctx, factory.createErrorMessage(request.requestID, str));
    }

    private void sendResponse(ChannelHandlerContext ctx, DOIPV3Message response) {
        ctx.writeAndFlush(response);
    }
}
