/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.doip.endpoint;

import com.google.gson.Gson;
import java.net.URI;
import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bdware.doip.endpoint.client.ClientConfig;
import org.bdware.doip.endpoint.client.DoipClientChannel;
import org.bdware.doip.endpoint.client.NettyDoipTCPClientChannel;
import org.bdware.doip.endpoint.client.NettyDoipTLSClientChannel;
import org.bdware.doip.endpoint.client.NettyDoipUDPClientChannel;
import org.bdware.doip.endpoint.client.NettyDoipWSClientChannel;
import org.bdware.doip.endpoint.client.TLSClientConfig;
import org.bdware.doip.endpoint.server.DoipListener;
import org.bdware.doip.endpoint.server.DoipListenerConfig;
import org.bdware.doip.endpoint.server.NettyDoipListener;
import org.bdware.doip.endpoint.server.NettyTCPDoipListener;
import org.bdware.doip.endpoint.server.NettyTLSDoipListener;
import org.bdware.doip.endpoint.server.NettyUDPDoipListener;
import org.bdware.doip.endpoint.server.NettyWSDoipListener;
import org.bdware.doip.endpoint.server.TLSListenerInfo;
import org.bdware.doip.endpoint.v2_0.DOIPV2ClientChannel;
import org.bdware.doip.endpoint.v2_0.DOIPV2DoipListener;

public class EndpointFactory {
    static Logger LOGGER = LogManager.getLogger(NettyDoipListener.class);
    static HashMap<String, DoipListener> adhocListeners = new HashMap();
    static HashMap<String, DoipClientChannel> adhocClient = new HashMap();

    public static DoipListener createDoipListener(DoipListenerConfig listenerInfo) {
        switch (listenerInfo.protocolVersion) {
            case "2.1": {
                return V2_1.createDoipListener(listenerInfo);
            }
            case "2.0": {
                return V2_0.createDoipListener(listenerInfo);
            }
        }
        LOGGER.error("[Create repository error] Unsupported version: " + listenerInfo.protocolVersion);
        return null;
    }

    public static DoipClientChannel createDoipClientChannel(ClientConfig config) {
        switch (config.protocolVersion) {
            case "2.1": {
                return V2_1.createDoipClientChannel(config);
            }
            case "2.0": {
                return V2_0.createDoipClientChannel(config);
            }
        }
        LOGGER.error("[Create client error] Unsupported version: " + config.protocolVersion);
        return null;
    }

    public static void addDoipListener(String schema, DoipListener listener) {
        adhocListeners.put(schema, listener);
    }

    public static void addClientChannel(String schema, DoipClientChannel channel) {
        adhocClient.put(schema, channel);
    }

    static class V2_0 {
        V2_0() {
        }

        public static DoipListener createDoipListener(DoipListenerConfig listenerInfo) {
            try {
                URI uri = new URI(listenerInfo.url);
                switch (uri.getScheme()) {
                    case "tls": 
                    case "TLS": {
                        TLSListenerInfo tlinfo = (TLSListenerInfo)listenerInfo;
                        return new DOIPV2DoipListener(uri.getPort(), tlinfo);
                    }
                }
                if (adhocListeners.get(uri.getScheme()) != null) {
                    return adhocListeners.get(uri.getScheme());
                }
                LOGGER.error("[Create repository error] Unsupported Listener: " + new Gson().toJson((Object)listenerInfo));
                return null;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        public static DoipClientChannel createDoipClientChannel(ClientConfig config) {
            try {
                URI uri = new URI(config.url);
                LOGGER.debug("[URI Parse]scheme:" + uri.getScheme() + "host: " + uri.getHost() + "  port: " + uri.getPort());
                switch (uri.getScheme()) {
                    case "tls": 
                    case "TLS": {
                        TLSClientConfig tlsClientConfig = (TLSClientConfig)config;
                        return new DOIPV2ClientChannel(tlsClientConfig.managers);
                    }
                }
                if (adhocClient.get(uri.getScheme()) != null) {
                    return adhocClient.get(uri.getScheme());
                }
                LOGGER.error("[Create repository error] Unsupported URL: " + config.url);
                return null;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
    }

    static class V2_1 {
        V2_1() {
        }

        public static DoipListener createDoipListener(DoipListenerConfig listenerInfo) {
            try {
                URI uri = new URI(listenerInfo.url);
                LOGGER.debug("[URI Parse]scheme:" + uri.getScheme() + "; host: " + uri.getHost() + "  port: " + uri.getPort());
                switch (uri.getScheme().toLowerCase()) {
                    case "udp": {
                        return new NettyUDPDoipListener(uri.getPort(), listenerInfo);
                    }
                    case "tcp": {
                        return new NettyTCPDoipListener(uri.getPort(), listenerInfo);
                    }
                    case "tls": {
                        TLSListenerInfo tlinfo = (TLSListenerInfo)listenerInfo;
                        return new NettyTLSDoipListener(uri.getPort(), tlinfo);
                    }
                    case "ws": {
                        return new NettyWSDoipListener(uri.getPort(), uri.getPath(), listenerInfo);
                    }
                }
                if (adhocListeners.get(uri.getScheme()) != null) {
                    return adhocListeners.get(uri.getScheme());
                }
                LOGGER.error("[Create repository error] Unsupported Listener: " + new Gson().toJson((Object)listenerInfo));
                return null;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        public static DoipClientChannel createDoipClientChannel(ClientConfig config) {
            try {
                URI uri = new URI(config.url);
                LOGGER.debug("[URI Parse]scheme:" + uri.getScheme() + "host: " + uri.getHost() + "  port: " + uri.getPort());
                switch (uri.getScheme().toLowerCase()) {
                    case "udp": {
                        return new NettyDoipUDPClientChannel();
                    }
                    case "tcp": {
                        return new NettyDoipTCPClientChannel(config);
                    }
                    case "tls": {
                        TLSClientConfig tlsClientConfig = (TLSClientConfig)config;
                        return new NettyDoipTLSClientChannel(tlsClientConfig.managers);
                    }
                    case "ws": {
                        return new NettyDoipWSClientChannel();
                    }
                }
                if (adhocClient.get(uri.getScheme()) != null) {
                    return adhocClient.get(uri.getScheme());
                }
                LOGGER.error("[Create repository error] Unsupported URL: " + config.url);
                return null;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
    }

    static class V3 {
        V3() {
        }

        public static DoipListener createDoipListener(DoipListenerConfig listenerInfo) {
            try {
                URI uri = new URI(listenerInfo.url);
                LOGGER.debug("[URI Parse]scheme:" + uri.getScheme() + "; host: " + uri.getHost() + "  port: " + uri.getPort());
                switch (uri.getScheme().toLowerCase()) {
                    case "udp": {
                        return new NettyUDPDoipListener(uri.getPort(), listenerInfo);
                    }
                    case "tcp": {
                        return new NettyTCPDoipListener(uri.getPort(), listenerInfo);
                    }
                    case "tls": {
                        TLSListenerInfo tlinfo = (TLSListenerInfo)listenerInfo;
                        return new NettyTLSDoipListener(uri.getPort(), tlinfo);
                    }
                    case "ws": {
                        return new NettyWSDoipListener(uri.getPort(), uri.getPath(), listenerInfo);
                    }
                }
                if (adhocListeners.get(uri.getScheme()) != null) {
                    return adhocListeners.get(uri.getScheme());
                }
                LOGGER.error("[Create repository error] Unsupported Listener: " + new Gson().toJson((Object)listenerInfo));
                return null;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        public static DoipClientChannel createDoipClientChannel(ClientConfig config) {
            try {
                URI uri = new URI(config.url);
                LOGGER.debug("[URI Parse]scheme:" + uri.getScheme() + "host: " + uri.getHost() + "  port: " + uri.getPort());
                switch (uri.getScheme().toLowerCase()) {
                    case "udp": {
                        return new NettyDoipUDPClientChannel();
                    }
                    case "tcp": {
                        return new NettyDoipTCPClientChannel(config);
                    }
                    case "tls": {
                        TLSClientConfig tlsClientConfig = (TLSClientConfig)config;
                        return new NettyDoipTLSClientChannel(tlsClientConfig.managers);
                    }
                    case "ws": {
                        return new NettyDoipWSClientChannel();
                    }
                }
                if (adhocClient.get(uri.getScheme()) != null) {
                    return adhocClient.get(uri.getScheme());
                }
                LOGGER.error("[Create repository error] Unsupported URL: " + config.url);
                return null;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
    }
}

