/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.doip.endpoint.client.v3;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.net.URISyntaxException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bdware.doip.codec.exception.DoipConnectException;
import org.bdware.doip.codec.v3.DOIPV3Message;
import org.bdware.doip.codec.v3.V3MsgFactory;
import org.bdware.doip.endpoint.client.ClientConfig;
import org.bdware.doip.endpoint.client.v3.MessageCallback;
import org.bdware.doip.endpoint.client.v3.TCPClientChannel;

public class Client {
    TCPClientChannel clientChannel;
    String serverURL = null;
    Logger logger = LogManager.getLogger(Client.class);
    V3MsgFactory factory = new V3MsgFactory();
    int timeoutSeconds = 5;

    public DOIPV3Message sendMessageSync(DOIPV3Message doipMessage, long timeout) {
        CompletableFuture result = new CompletableFuture();
        this.sendMessage(doipMessage, result::complete);
        try {
            return (DOIPV3Message)result.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            ByteArrayOutputStream bo = new ByteArrayOutputStream();
            e.printStackTrace(new PrintStream(bo));
            return this.factory.createErrorMessage(doipMessage.requestID, bo.toString());
        }
    }

    public void sendMessage(DOIPV3Message msg, MessageCallback<DOIPV3Message> cb) {
        if (!this.isConnected() && !this.tryReconnect()) {
            this.logger.warn("channel not connect yet! " + (this.clientChannel == null) + " --> serverUrl:" + this.serverURL);
            cb.onResult(this.factory.createErrorMessage(msg.requestID, "Failed to connect channel:" + this.serverURL));
            return;
        }
        this.clientChannel.sendMessage(msg, cb);
    }

    public void close() {
        this.clientChannel.close();
        this.clientChannel = null;
    }

    public void connect(ClientConfig config) {
        try {
            this.serverURL = config.url;
            this.clientChannel = new TCPClientChannel(config);
            if (this.clientChannel == null) {
                return;
            }
            this.clientChannel.connect(this.serverURL);
            this.clientChannel.setTimeoutSecond(config.timeoutSeconds);
        }
        catch (URISyntaxException e) {
            this.logger.error("UUUUUURISyntaxException Exception!");
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            this.logger.error("IIIIInterruped Exception!");
            throw new RuntimeException(e);
        }
    }

    public void reconnect() throws DoipConnectException {
        if (this.serverURL == null) {
            throw new DoipConnectException("target URL not set, use .connect(url) first");
        }
        ClientConfig clientConfig = ClientConfig.fromUrl(this.serverURL);
        if (this.clientChannel == null) {
            this.clientChannel = new TCPClientChannel(clientConfig);
        }
        if (this.clientChannel == null) {
            return;
        }
        try {
            this.clientChannel.connect(this.serverURL);
        }
        catch (InterruptedException | URISyntaxException e) {
            e.printStackTrace();
        }
    }

    public void reconnect(String url) throws DoipConnectException {
        this.serverURL = url;
        if (this.serverURL == null) {
            throw new DoipConnectException("target URL not set, use .connect(url) first");
        }
        ClientConfig clientConfig = ClientConfig.fromUrl(this.serverURL);
        if (this.clientChannel == null) {
            this.clientChannel = new TCPClientChannel(clientConfig);
        }
        if (this.clientChannel == null) {
            return;
        }
        try {
            this.clientChannel.connect(this.serverURL);
        }
        catch (InterruptedException | URISyntaxException e) {
            e.printStackTrace();
        }
    }

    public boolean isConnected() {
        return this.clientChannel != null && this.clientChannel.isConnected();
    }

    public void waitForConnected() {
        for (int i = 0; !(i >= 100 || this.clientChannel != null && this.clientChannel.isConnected()); ++i) {
            try {
                Thread.sleep(20L);
                continue;
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private boolean tryReconnect() {
        try {
            this.reconnect();
        }
        catch (DoipConnectException e) {
            throw new RuntimeException(e);
        }
        return this.isConnected();
    }
}

