/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.doip.endpoint.client.v3;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.bdware.doip.codec.v3.DOIPCodec;
import org.bdware.doip.codec.v3.DOIPV3Printer;
import org.bdware.doip.endpoint.client.ClientConfig;
import org.bdware.doip.endpoint.client.v3.ClientChannelBase;
import org.bdware.doip.endpoint.client.v3.ClientHandler;

public class TCPClientChannel
extends ClientChannelBase {
    Bootstrap b;
    static EventLoopGroup group;
    boolean splitEnvelop;
    int maxFrameLength;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TCPClientChannel(boolean splitEnvelop, final int maxFrameLength, ClientConfig config) {
        this.splitEnvelop = splitEnvelop;
        this.maxFrameLength = maxFrameLength;
        this.handler = new ClientHandler();
        Class<TCPClientChannel> clazz = TCPClientChannel.class;
        synchronized (TCPClientChannel.class) {
            if (group == null) {
                group = new NioEventLoopGroup(new ThreadFactory(){

                    @Override
                    public Thread newThread(Runnable r) {
                        Thread thread = Executors.defaultThreadFactory().newThread(r);
                        thread.setDaemon(true);
                        return thread;
                    }
                });
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            this.b = new Bootstrap();
            ((Bootstrap)((Bootstrap)((Bootstrap)this.b.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)5000)).option(ChannelOption.SO_KEEPALIVE, (Object)true)).option(ChannelOption.SO_REUSEADDR, (Object)true)).option(ChannelOption.SO_LINGER, (Object)0);
            this.b.option(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)new WriteBufferWaterMark(2 * maxFrameLength, 10 * maxFrameLength));
            this.b.group(group);
            ((Bootstrap)((Bootstrap)this.b.channel(NioSocketChannel.class)).option(ChannelOption.TCP_NODELAY, (Object)true)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel ch) {
                    ChannelPipeline p = ch.pipeline();
                    p.addLast(new ChannelHandler[]{new LengthFieldBasedFrameDecoder(maxFrameLength, 20, 4, 0, 0)}).addLast(new ChannelHandler[]{new DOIPCodec()}).addLast(new ChannelHandler[]{new DOIPV3Printer()});
                    p.addLast(new ChannelHandler[]{TCPClientChannel.this.handler});
                }
            });
            return;
        }
    }

    public TCPClientChannel(ClientConfig config) {
        this(false, 0x500000, config);
    }

    public void close() {
        try {
            this.channel.unsafe().closeForcibly();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.handler != null) {
            try {
                this.handler.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.isConnected = false;
    }

    @Override
    public void connect(String targetUrl) throws URISyntaxException, InterruptedException {
        URI uri = new URI(targetUrl);
        this.channel = this.b.connect(uri.getHost(), uri.getPort()).sync().channel();
        this.handler.setChannel(this.channel);
        this.channel.config().setOption(ChannelOption.SO_LINGER, (Object)0);
        this.isConnected = true;
    }
}

