package org.bdware.doip.codec.v3;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageCodec;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import java.util.List;

public abstract class DOIPV3Handler<T> extends MessageToMessageCodec<DOIPV3Message, T> {

    static Logger LOGGER = LogManager.getLogger(DOIPV3Handler.class);

    @Override
    protected abstract void encode(ChannelHandlerContext ctx, T msg, List<Object> out) throws Exception;

    @Override
    protected abstract void decode(ChannelHandlerContext ctx, DOIPV3Message in, List<Object> out) throws Exception;

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        LOGGER.debug("DOIPV3Handler got exception: " + cause.getMessage());
        cause.printStackTrace();
    }
}
