package org.bdware.doip.codec.v3.headers;

import io.netty.buffer.ByteBuf;

public class EnvelopeWrapper extends ExtensionPart {
    public static final int EXTENSION_CODE = 2;

    public EnvelopeWrapper(ByteBuf buf) {
        nextType = 0;
        messageEnvelopeByteBuf = buf.retainedDuplicate();
        buf.readerIndex(buf.readerIndex() + buf.readableBytes());
        //messageEnvelopeByteBuf = buf.retainedDuplicate();
        //buf.release(1);
    }

    @Override
    public void finalize() {
        if (messageEnvelopeByteBuf != null)
            messageEnvelopeByteBuf.release();
    }

    public ByteBuf messageEnvelopeByteBuf;

    @Override
    public boolean hasNextPart() {
        return false;
    }

    @Override
    public void writeTo(ByteBuf bf) {
        bf.writeBytes(messageEnvelopeByteBuf);
    }

    @Override
    public int length() {
        return messageEnvelopeByteBuf.readableBytes();
    }

    @Override
    public int getType() {
        return EXTENSION_CODE;
    }

    @Override
    public String prettyPrint() {
        return "EnvelopeWrapper len:" + messageEnvelopeByteBuf.readableBytes();
    }

}
