/*
 *    Copyright (c) [2021] [Peking University]
 *    [BDWare DOIP SDK] is licensed under Mulan PSL v2.
 *    You can use this software according to the terms and conditions of the Mulan PSL v2.
 *    You may obtain a copy of Mulan PSL v2 at:
 *             http://license.coscl.org.cn/MulanPSL2
 *    THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT, MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 *    See the Mulan PSL v2 for more details.
 */

package org.bdware.doip.endpoint.client.v3;

import io.netty.channel.Channel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bdware.doip.codec.v3.DOIPV3Message;

import java.net.URISyntaxException;

public abstract class ClientChannelBase {
    static Logger logger = LogManager.getLogger(ClientChannelBase.class);
    protected ClientHandler handler;
    protected boolean isConnected = false;
    protected Channel channel;
    protected int timeoutSecond = 5;

    public void sendMessage(DOIPV3Message message, MessageCallback<DOIPV3Message> cb) {
        if (handler == null) {
            logger.error("client handler not set yet");
            return;
        }
        if (!isConnected) {
            logger.error("client not connected, connect first!");
        }
        logger.info("channel send message");
        handler.sendMessage(message, cb, timeoutSecond);
    }

    abstract public void connect(String url) throws URISyntaxException, InterruptedException;

    public boolean isConnected() {
        return channel != null && channel.isOpen() && channel.isActive();
    }

    public void setTimeoutSecond(int ts) {
        this.timeoutSecond = ts;
    }

}
