/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.doip.codec.v3.headers;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import org.bdware.doip.codec.v3.headers.ExtensionPart;

public class DOLHeader
extends ExtensionPart {
    public static final int EXTENSION_CODE = 1;
    private int dolLength;
    private byte[] dol;

    public DOLHeader(ByteBuf bf) {
        this.nextType = bf.readInt();
        this.dolLength = bf.readInt();
        if (this.dolLength > 0) {
            this.dol = new byte[this.dolLength];
            bf.readBytes(this.dol);
        }
    }

    public DOLHeader() {
    }

    public void setDOL(byte[] newDol) {
        if (newDol == null) {
            this.dolLength = 0;
        } else {
            this.dol = newDol;
            this.dolLength = this.dol.length;
        }
    }

    @Override
    public void writeTo(ByteBuf bf) {
        bf.writeInt(this.nextType);
        if (this.dol != null && this.dol.length > 0) {
            bf.writeInt(this.dol.length);
            bf.writeBytes(this.dol);
        } else {
            bf.writeInt(0);
        }
    }

    @Override
    public int length() {
        return 4 + (this.dol == null ? 0 : this.dol.length);
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public String prettyPrint() {
        return "DOLHeader dol:" + ByteBufUtil.hexDump((byte[])this.dol);
    }

    public byte[] getDol() {
        return this.dol;
    }
}

