/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.doip.endpoint.client.v3;

import io.netty.channel.Channel;
import java.net.URISyntaxException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bdware.doip.codec.v3.DOIPV3Message;
import org.bdware.doip.endpoint.client.v3.ClientHandler;
import org.bdware.doip.endpoint.client.v3.MessageCallback;

public abstract class ClientChannelBase {
    static Logger logger = LogManager.getLogger(ClientChannelBase.class);
    protected ClientHandler handler;
    protected boolean isConnected = false;
    protected Channel channel;
    protected int timeoutSecond = 5;

    public void sendMessage(DOIPV3Message message, MessageCallback<DOIPV3Message> cb) {
        if (this.handler == null) {
            logger.error("client handler not set yet");
            return;
        }
        if (!this.isConnected) {
            logger.error("client not connected, connect first!");
        }
        logger.info("channel send message");
        this.handler.sendMessage(message, cb, this.timeoutSecond);
    }

    public abstract void connect(String var1) throws URISyntaxException, InterruptedException;

    public boolean isConnected() {
        return this.channel != null && this.channel.isOpen() && this.channel.isActive();
    }

    public void setTimeoutSecond(int ts) {
        this.timeoutSecond = ts;
    }
}

