/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.doip.endpoint.client.v3;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Random;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bdware.doip.codec.v3.DOIPV3Message;
import org.bdware.doip.codec.v3.TimeoutMsgFactory;
import org.bdware.doip.codec.v3.headers.ExceptionHead;
import org.bdware.doip.endpoint.client.v3.MessageCallback;
import org.bdware.doip.endpoint.client.v3.ResponseWait;

@ChannelHandler.Sharable
public class ClientHandler
extends SimpleChannelInboundHandler<DOIPV3Message> {
    static Logger logger = LogManager.getLogger(ClientHandler.class);
    public Channel channel;
    public TimeoutMsgFactory<DOIPV3Message> timeoutFactor = new TimeoutMsgFactory<DOIPV3Message>(){

        @Override
        public DOIPV3Message createTimoutMessage(long requestId, DOIPV3Message request, long timeout, String msg) {
            DOIPV3Message message = new DOIPV3Message();
            message.requestID = requestId;
            ExceptionHead exception = new ExceptionHead();
            exception.code = 2;
            exception.setContent(msg.getBytes(StandardCharsets.UTF_8));
            message.appendPart(exception);
            return message;
        }
    };
    ResponseWait sync = new ResponseWait<DOIPV3Message>(this.timeoutFactor);
    Random random = new Random();

    public void sendMessage(DOIPV3Message request, MessageCallback callback) {
        this.sendMessage(request, callback, 30);
    }

    public void sendMessage(DOIPV3Message request, MessageCallback callback, int timeoutSeconds) {
        if (callback == null) {
            logger.error("DoipMessageCallback is null, please check!");
            return;
        }
        int retryCount = 0;
        if (request.requestID == 0L) {
            request.requestID = this.random.nextLong();
        }
        int MAX_RETRY_COUNT = 5;
        while (retryCount < MAX_RETRY_COUNT && !this.sync.waitResponse(request.requestID, callback, timeoutSeconds)) {
            request.requestID = this.random.nextLong();
            Thread.yield();
            ++retryCount;
        }
        if (retryCount >= MAX_RETRY_COUNT) {
            logger.error("waitObj.size() is too large! Could not get response: " + request.requestID);
            DOIPV3Message response = this.timeoutFactor.createTimoutMessage(request.requestID, request, 0L, "waitObj.size too large!");
            callback.onResult(response);
        } else {
            this.channel.writeAndFlush((Object)request);
        }
    }

    public DOIPV3Message sendMessageSync(DOIPV3Message request, int timeoutSeconds) {
        final ArrayList ret = new ArrayList();
        MessageCallback<DOIPV3Message> cb = new MessageCallback<DOIPV3Message>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onResult(DOIPV3Message msg) {
                ret.add(msg);
                2 var2_2 = this;
                synchronized (var2_2) {
                    this.notify();
                }
            }
        };
        this.sendMessage(request, cb, timeoutSeconds);
        try {
            cb.wait((long)timeoutSeconds * 1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (ret.size() > 0) {
            return (DOIPV3Message)ret.get(0);
        }
        DOIPV3Message response = this.timeoutFactor.createTimoutMessage(request.requestID, request, 0L, "[NettyDoipClientHandler.sendMessageSync]");
        return response;
    }

    public void close() {
        this.channel.close();
    }

    public void setChannel(Channel c) {
        this.channel = c;
    }

    protected void channelRead0(ChannelHandlerContext ctx, DOIPV3Message msg) {
        logger.debug("channelRead0 receive a message");
        this.sync.wakeUpAndRemove(msg.requestID, msg);
    }
}

