/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.doip.endpoint.client.v3;

import io.netty.util.HashedWheelTimer;
import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bdware.doip.codec.v3.TimeoutMsgFactory;
import org.bdware.doip.endpoint.client.v3.MessageCallback;

public class ResponseWait<T> {
    static Logger LOGGER = LogManager.getLogger(ResponseWait.class);
    public static final HashedWheelTimer HASHED_WHEEL_TIMER = new HashedWheelTimer(r -> {
        Thread t = Executors.defaultThreadFactory().newThread(r);
        t.setDaemon(true);
        return t;
    }, 5L, TimeUnit.MILLISECONDS, 2);
    private final TimeoutMsgFactory<T> factory;
    final Map<Long, Pair<MessageCallback<T>, Timeout>> waitObj = new ConcurrentHashMap<Long, Pair<MessageCallback<T>, Timeout>>();
    static AtomicInteger total = new AtomicInteger(0);

    public ResponseWait(TimeoutMsgFactory<T> factory) {
        this.factory = factory;
    }

    public void wakeUpAndRemove(long requestID, T result) {
        Pair<MessageCallback<T>, Timeout> ob = this.getAndRemove(requestID);
        this.wakeup(ob, result);
    }

    private Pair<MessageCallback<T>, Timeout> getAndRemove(long requestID) {
        Pair<MessageCallback<T>, Timeout> ob = this.waitObj.remove(requestID);
        if (ob != null && ob.second != null) {
            ((Timeout)ob.second).cancel();
            return ob;
        }
        return null;
    }

    public boolean waitResponseFor5Secs(long requestID, MessageCallback cb) {
        return this.waitResponse(requestID, cb, 5);
    }

    public boolean waitResponse(long requestID, MessageCallback<T> cb, int seconds) {
        TimerTask tt = timeout -> {
            T timeOutMessage = this.factory.createTimoutMessage(requestID, null, seconds, "[ResponseWait.waitResponse]");
            this.wakeUpAndRemove(requestID, timeOutMessage);
        };
        Timeout timeout2 = HASHED_WHEEL_TIMER.newTimeout(tt, (long)seconds, TimeUnit.SECONDS);
        Pair<MessageCallback<T>, Timeout> value = new Pair<MessageCallback<T>, Timeout>(cb, timeout2);
        Pair<MessageCallback<T>, Timeout> oldValue = this.waitObj.putIfAbsent(requestID, value);
        if (oldValue == null) {
            return true;
        }
        LOGGER.debug("Response Wait \u8fd4\u56defalse\uff0c\u518d\u6b21\u5c1d\u8bd5\uff01");
        timeout2.cancel();
        return false;
    }

    public void wakeup(long requestID, T result) {
        Pair<MessageCallback<T>, Timeout> ob = this.waitObj.get(requestID);
        this.wakeup(ob, result);
    }

    public void wakeup(Pair<MessageCallback<T>, Timeout> ob, T result) {
        if (ob != null) {
            LOGGER.info("cancel timeout timertask");
            ((Timeout)ob.second).cancel();
            ((MessageCallback)ob.first).onResult(result);
        }
    }

    public static class Pair<T, U> {
        final T first;
        final U second;

        Pair(T t, U u) {
            this.first = t;
            this.second = u;
        }
    }
}

