package org.bdware.doip.codec.v3;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageCodec;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import java.util.List;

public class DOIPV3Codec extends ByteToMessageCodec<DOIPV3Message> {

    static Logger LOGGER = LogManager.getLogger(DOIPV3Message.class);

    @Override
    protected void encode(ChannelHandlerContext ctx, DOIPV3Message msg, ByteBuf out) throws Exception {
        LOGGER.info("[DOIPV3Codec Send] " + msg.prettyPrint() + " from:" + ctx.channel().remoteAddress().toString());
        msg.writeTo(out);
    }
    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        ByteBuf toPrint = in.duplicate();
        byte[] result = ByteBufUtil.getBytes(toPrint);
        LOGGER.info("[DOIPV3Codec RECV]  from:" + ctx.channel().remoteAddress().toString() + " len:" + toPrint.readableBytes() + "-->:" + ByteBufUtil.hexDump(result));
        DOIPV3Message v3Msg = new DOIPV3Message();
        v3Msg.readFrom(in);
        out.add(v3Msg);
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        LOGGER.debug("DOIPV3Codec got exception: " + cause.getMessage());
        cause.printStackTrace();
    }
}
