/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.doip.codec.digitalObject;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.bdware.doip.codec.digitalObject.DigitalObject;
import org.bdware.doip.codec.digitalObject.DoType;
import org.bdware.doip.codec.digitalObject.Element;
import org.bdware.doip.codec.exception.DoDecodeException;

public class DOList
extends DigitalObject {
    public DOList(String id) {
        super(id, DoType.DOList);
    }

    public void addDO(DigitalObject digitalObject) {
        Element e = new Element(digitalObject.id, DoType.DO.getName());
        e.setData(digitalObject.toByteArray());
        this.addElements(e);
    }

    public boolean deleteDO(String doi) {
        for (int i = 0; i < this.elements.size(); ++i) {
            if (!((Element)this.elements.get((int)i)).id.equals(doi)) continue;
            this.elements.remove(i);
            return true;
        }
        return false;
    }

    public List<DigitalObject> getDOList() throws IOException, DoDecodeException {
        ArrayList<DigitalObject> doList = new ArrayList<DigitalObject>();
        for (Element e : this.elements) {
            DigitalObject t = DigitalObject.fromByteArray(e.getData());
            doList.add(t);
        }
        return doList;
    }

    public static DOList fromDigitalObject(DigitalObject digitalObject) {
        DOList doList = new DOList(digitalObject.id);
        doList.elements = digitalObject.elements;
        doList.attributes = digitalObject.attributes;
        return doList;
    }
}

